/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreSide;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class PacketContext {
    private final CustomPayloadEvent.Context context;

    public PacketContext(CustomPayloadEvent.Context context) {
        this.context = context;
    }

    public CoreSide getHandlingSide() {
        return this.context.isClientSide() ? CoreSide.CLIENT : CoreSide.SERVER;
    }

    public CoreSide getOriginatingSide() {
        return this.context.isServerSide() ? CoreSide.CLIENT : CoreSide.SERVER;
    }

    public Player getPlayer() {
        ServerPlayer serverPlayer;
        if (this.context.isClientSide()) {
            return ClientUtils.getPlayer();
        }
        Connection connection = this.context.getConnection();
        PacketListener packetListener = connection.getPacketListener();
        if (packetListener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)packetListener;
            serverPlayer = listener.getPlayer();
        } else {
            serverPlayer = null;
        }
        return serverPlayer;
    }

    @Deprecated
    public Player getSendingPlayer() {
        return this.context.getSender();
    }

    public Level getWorld() {
        return this.getHandlingSide() == CoreSide.CLIENT ? ClientUtils.getWorld() : this.getSendingPlayer().level();
    }

    public void queueTask(Runnable task) {
        this.context.enqueueWork(task);
    }

    @Deprecated
    public CustomPayloadEvent.Context getUnderlyingContext() {
        return this.context;
    }
}

