/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.network.PacketDirection;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.payload.PayloadFlow;

public class PacketChannel {
    private final String modid;
    private final String name;
    private final Identifier channelName;
    private final CustomPacketPayload.Type<Payload> payloadType;
    private final Channel<CustomPacketPayload> channel;
    private final List<PacketProperties<?>> packetsByIndex = new ArrayList();
    private final Map<Class<? extends BasePacket>, PacketProperties<?>> packetsByClass = new HashMap();

    public static PacketChannel create(String modid, String channelName) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(channelName)) {
            throw new IllegalArgumentException("Channel name '" + channelName + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '{}' is creating a packet channel for different modid '{}'!", (Object)ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName(), (Object)modid);
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a packet channel for modid '{}'!", (Object)modid);
        }
        return new PacketChannel(modid, channelName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    @Deprecated
    public static PacketChannel create() {
        return PacketChannel.create(ModLoadingContext.get().getActiveNamespace(), "main");
    }

    private PacketChannel(String modid, String name) {
        this.modid = modid;
        this.name = name;
        this.channelName = Identifier.fromNamespaceAndPath((String)modid, (String)name);
        this.payloadType = new CustomPacketPayload.Type(this.channelName);
        StreamCodec payloadCodec = StreamCodec.of((buffer, payload) -> this.write(payload.packet, (FriendlyByteBuf)buffer), buffer -> new Payload(this.read((FriendlyByteBuf)buffer)));
        this.channel = ((PayloadFlow)ChannelBuilder.named((Identifier)Identifier.fromNamespaceAndPath((String)modid, (String)name)).networkProtocolVersion(1).acceptedVersions((status, version) -> version == 1).payloadChannel().any().bidirectional()).add(this.payloadType, payloadCodec, (payload, context) -> {
            context.setPacketHandled(true);
            this.handle(payload.packet, new PacketContext((CustomPayloadEvent.Context)context), context.isClientSide() ? PacketDirection.SERVER_TO_CLIENT : PacketDirection.CLIENT_TO_SERVER);
        }).build();
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, PacketDirection direction, boolean shouldBeQueued) {
        if (this.packetsByClass.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + String.valueOf(packetClass) + "' has already been registered!");
        }
        int index = this.packetsByIndex.size();
        PacketProperties<T> properties = new PacketProperties<T>(index, packetClass, packetSupplier, direction, shouldBeQueued);
        this.packetsByIndex.add(properties);
        this.packetsByClass.put(packetClass, properties);
    }

    @Deprecated
    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        this.registerMessage(packetClass, packetSupplier, PacketDirection.BOTH_WAYS, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.CLIENT_TO_SERVER);
        this.channel.send((Object)new Payload(packet), PacketDistributor.SERVER.noArg());
    }

    public void sendToClient(Connection connection, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        if (connection.getReceiving() == PacketFlow.CLIENTBOUND) {
            throw new IllegalArgumentException("This must only be called server-side!");
        }
        if (connection.getPacketListener() instanceof ServerConfigurationPacketListenerImpl) {
            this.channel.send((Object)new Payload(packet), PacketDistributor.NMLIST.with(List.of(connection)));
        } else {
            PacketListener packetListener = connection.getPacketListener();
            if (packetListener instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)packetListener;
                this.channel.send((Object)new Payload(packet), PacketDistributor.PLAYER.with((Object)listener.player));
            } else {
                throw new IllegalArgumentException("Cannot send packet during the current network stage!");
            }
        }
    }

    public void sendToPlayer(Player player, BasePacket packet) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send((Object)new Payload(packet), PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)));
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send((Object)new Payload(packet), PacketDistributor.ALL.noArg());
    }

    public void sendToDimension(ResourceKey<Level> dimension, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send((Object)new Payload(packet), PacketDistributor.DIMENSION.with(dimension));
    }

    public void sendToDimension(Level world, BasePacket packet) {
        if (!(world instanceof ServerLevel)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToDimension((ResourceKey<Level>)world.dimension(), packet);
    }

    public void sendToAllTrackingEntity(Entity entity, BasePacket packet) {
        if (entity.level().isClientSide()) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send((Object)new Payload(packet), PacketDistributor.TRACKING_ENTITY.with((Object)entity));
    }

    public void sendToAllNear(ResourceKey<Level> world, double x, double y, double z, double radius, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        this.channel.send((Object)new Payload(packet), PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint(null, x, y, z, radius, world)));
    }

    public void sendToAllNear(ResourceKey<Level> world, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, radius, packet);
    }

    public void sendToAllNear(Level world, double x, double y, double z, double radius, BasePacket packet) {
        if (!(world instanceof ServerLevel)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear((ResourceKey<Level>)world.dimension(), x, y, z, radius, packet);
    }

    public void sendToAllNear(Level world, BlockPos pos, double radius, BasePacket packet) {
        if (world.isClientSide()) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet, PacketDirection direction) {
        PacketProperties<?> properties = this.packetsByClass.get(packet.getClass());
        if (properties == null) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + String.valueOf(packet.getClass()) + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        if (properties.direction != PacketDirection.BOTH_WAYS && properties.direction != direction) {
            throw new IllegalArgumentException("Tried to send packet '" + String.valueOf(packet.getClass()) + "' on channel '" + this.modid + ":" + this.name + "' in invalid direction '" + String.valueOf((Object)direction) + "'!");
        }
    }

    void write(BasePacket packet, FriendlyByteBuf buffer) {
        int index = this.packetsByClass.get(packet.getClass()).index;
        buffer.writeInt(index);
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst writing packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
    }

    BasePacket read(FriendlyByteBuf buffer) {
        int index = buffer.readInt();
        if (this.packetsByIndex.size() < index) {
            throw new RuntimeException("Received an unregistered packet with index '" + index + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        PacketProperties<?> properties = this.packetsByIndex.get(index);
        BasePacket packet = (BasePacket)properties.supplier().get();
        try {
            packet.read(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst reading packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
        return packet;
    }

    void handle(BasePacket packet, PacketContext context, PacketDirection direction) {
        PacketProperties<?> properties = this.packetsByClass.get(packet.getClass());
        if (properties.direction != PacketDirection.BOTH_WAYS && properties.direction != direction) {
            throw new RuntimeException("Received packet of class '" + String.valueOf(properties.clazz) + "' on channel '" + this.modid + ":" + this.name + "' for invalid direction '" + String.valueOf((Object)(direction == PacketDirection.CLIENT_TO_SERVER ? PacketDirection.SERVER_TO_CLIENT : PacketDirection.CLIENT_TO_SERVER)) + "'!");
        }
        try {
            boolean verify = packet.verify(context);
            if (!verify) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst verifying packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
        Runnable handle = () -> {
            try {
                packet.handle(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst processing packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
            }
        };
        if (properties.shouldBeQueued) {
            context.queueTask(handle);
        } else {
            handle.run();
        }
    }

    private record PacketProperties<T extends BasePacket>(int index, Class<T> clazz, Supplier<T> supplier, PacketDirection direction, boolean shouldBeQueued) {
    }

    class Payload
    implements CustomPacketPayload {
        private final BasePacket packet;

        private Payload(BasePacket packet) {
            this.packet = packet;
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PacketChannel.this.payloadType;
        }
    }
}

