/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.supermartijn642.core.data.tag.TagEntryAdapter;
import com.supermartijn642.core.extensions.TagLoaderExtension;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TagLoader.class})
public class TagLoaderMixin
implements TagLoaderExtension {
    @Unique
    private Registry<?> registry;

    @Override
    public void supermartijn642corelibSetRegistry(Registry<?> registry) {
        this.registry = registry;
    }

    @Inject(method={"loadTagsForRegistry"}, at={@At(value="INVOKE", target="Lnet/minecraft/tags/TagLoader;load(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Map;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void loadTagsForRegistry(ResourceManager resourceManager, WritableRegistry<?> registry, CallbackInfo ci, ResourceKey<?> key, TagLoader<?> tagLoader) {
        ((TagLoaderExtension)tagLoader).supermartijn642corelibSetRegistry((Registry<?>)registry);
    }

    @Inject(method={"loadPendingTags"}, at={@At(value="INVOKE", target="Lnet/minecraft/tags/TagLoader;load(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Map;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void loadPendingTags(ResourceManager resourceManager, Registry<?> registry, CallbackInfoReturnable<?> ci, ResourceKey<?> key, TagLoader<?> tagLoader) {
        ((TagLoaderExtension)tagLoader).supermartijn642corelibSetRegistry(registry);
    }

    @Inject(method={"build(Ljava/util/Map;)Ljava/util/Map;"}, at={@At(value="HEAD")})
    private void build(Map<Identifier, List<TagLoader.EntryWithSource>> tags, CallbackInfoReturnable<Map<?, ?>> ci) {
        for (List<TagLoader.EntryWithSource> tag : tags.values()) {
            for (TagLoader.EntryWithSource entry : tag) {
                if (!(entry.entry() instanceof TagEntryAdapter)) continue;
                ((TagEntryAdapter)entry.entry()).setRegistry(this.registry);
            }
        }
    }
}

