/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget.premade;

import com.mojang.blaze3d.platform.cursor.CursorType;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.CursorTypes;
import com.supermartijn642.core.gui.widget.BaseWidget;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractButtonWidget
extends BaseWidget {
    private final Runnable pressable;
    private boolean active = true;

    public AbstractButtonWidget(int x, int y, int width, int height, Runnable onPress) {
        super(x, y, width, height);
        this.pressable = onPress;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean isClickable() {
        return this.active;
    }

    public void onPress() {
        AbstractButtonWidget.playClickSound();
        if (this.pressable != null) {
            this.pressable.run();
        }
    }

    @Override
    public CursorType curser(int mouseX, int mouseY) {
        return this.isClickable() ? CursorTypes.pointingHand() : null;
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, MouseButtonInfo info, boolean isDoubleClick, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height && this.isClickable()) {
            this.onPress();
            return true;
        }
        return false;
    }

    public static void playClickSound() {
        ClientUtils.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }
}

