/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class WidgetScreen<T extends Widget>
extends Screen {
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final T widget;
    private boolean initialized = false;
    private boolean isPauseScreen = false;
    private boolean dragging = false;

    public static <T extends Widget> WidgetScreen<T> of(T widget) {
        return new WidgetScreen<T>(widget);
    }

    public static <T extends Widget> WidgetScreen<T> of(T widget, boolean isPauseScreen) {
        return new WidgetScreen<T>(widget, isPauseScreen);
    }

    public WidgetScreen(T widget, boolean isPauseScreen) {
        super((Component)TextComponents.empty().get());
        this.widget = widget;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetScreen(T widget) {
        this(widget, false);
    }

    protected void init() {
        if (!this.initialized) {
            this.widget.initialize();
            this.initialized = true;
        }
    }

    public void onClose() {
        this.widget.discard();
        super.onClose();
    }

    public void tick() {
        this.widget.update();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.widgetRenderContext.update(guiGraphics, partialTicks, this.font, this.minecraft);
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        mouseX -= offsetX;
        mouseY -= offsetY;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        if (!this.dragging) {
            this.widget.setFocused(mouseX >= 0 && mouseX < this.widget.width() && mouseY >= 0 && mouseY < this.widget.height());
        }
        GuiGraphicsHelper helper = GuiGraphicsHelper.of(guiGraphics);
        this.widget.renderBackground(this.widgetRenderContext, helper, mouseX, mouseY);
        this.widget.render(this.widgetRenderContext, helper, mouseX, mouseY);
        this.widget.renderForeground(this.widgetRenderContext, helper, mouseX, mouseY);
        this.widget.renderOverlay(this.widgetRenderContext, helper, mouseX, mouseY);
        this.widget.renderTooltips(this.widgetRenderContext, helper, mouseX, mouseY);
        guiGraphics.pose().popMatrix();
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        int mouseY;
        this.dragging = true;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mousePressed(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), isDoubleClick, false) || super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        int mouseY;
        this.dragging = false;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mouseReleased(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), false) || super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        int mouseY;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mouseDragged(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), deltaX, deltaY, false) || super.mouseDragged(event, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.height - this.widget.height()) / 2)), verticalAmount, false) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.widget.keyPressed(event, false)) {
            return true;
        }
        if (ClientUtils.getMinecraft().options.keyInventory.matches(event)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean keyReleased(KeyEvent event) {
        return this.widget.keyReleased(event, false) || super.keyReleased(event);
    }

    public boolean charTyped(CharacterEvent event) {
        return this.widget.charTyped((char)event.codepoint(), false) || super.charTyped(event);
    }

    public boolean isPauseScreen() {
        return this.isPauseScreen;
    }

    public Component getNarrationMessage() {
        Component message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

