/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.cursor.CursorType;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.CustomSlot;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.event.ForgeEventFactoryClient;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends AbstractContainerScreen<X> {
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;
    private boolean dragging = false;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container, ((BaseContainer)((Object)container)).player.getInventory(), (Component)TextComponents.empty().get());
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void init() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.imageWidth = this.widget.width();
        this.imageHeight = this.widget.height();
        super.init();
    }

    public void onClose() {
        this.widget.discard();
        super.onClose();
    }

    protected void containerTick() {
        this.widget.update();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        CustomSlot customSlot;
        CursorType curser;
        this.widgetRenderContext.update(guiGraphics, partialTicks, this.font, this.minecraft);
        GuiGraphicsHelper helper = GuiGraphicsHelper.of(guiGraphics);
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        if (!this.dragging) {
            this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        }
        if ((curser = this.widget.curser(offsetMouseX, offsetMouseY)) != null) {
            guiGraphics.requestCursor(curser);
        }
        this.widget.renderBackground(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).slots) {
                if (!slot.isActive()) continue;
                if (slot instanceof CustomSlot) {
                    customSlot = (CustomSlot)slot;
                    if (!customSlot.showBackground()) continue;
                    helper.submitDefaultSlot(slot.x - 1, slot.y - 1, customSlot.getWidth(), customSlot.getHeight());
                    continue;
                }
                helper.submitDefaultSlot(slot.x - 1, slot.y - 1);
            }
        }
        guiGraphics.pose().popMatrix();
        ForgeEventFactoryClient.onContainerRenderBackground((AbstractContainerScreen)this, (GuiGraphics)guiGraphics, (int)mouseX, (int)mouseY);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        this.widget.render(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        this.hoveredSlot = null;
        for (Slot slot : ((BaseContainer)((Object)this.container)).slots) {
            if (!slot.isActive()) continue;
            if (slot instanceof CustomSlot) {
                int slotHeight;
                customSlot = (CustomSlot)slot;
                int slotWidth = customSlot.getWidth();
                if (this.isHovering(slot.x, slot.y, slotWidth - 2, (slotHeight = customSlot.getHeight()) - 2, mouseX, mouseY)) {
                    this.hoveredSlot = slot;
                    if (customSlot.showHighlight() && slot.isHighlightable()) {
                        helper.submitSprite(AbstractContainerScreen.SLOT_HIGHLIGHT_BACK_SPRITE, (float)(slot.x - 4), (float)(slot.y - 4), (float)(slotWidth + 6), (float)(slotHeight + 6));
                    }
                }
                if (customSlot.showItem()) {
                    float scale = Math.min((float)slotWidth / 18.0f, (float)slotHeight / 18.0f);
                    guiGraphics.pose().pushMatrix();
                    if (customSlot.scaleItemToSize() && scale != 1.0f) {
                        guiGraphics.pose().translate((float)slot.x, (float)slot.y);
                        guiGraphics.pose().scale(scale);
                        guiGraphics.pose().translate((float)(-slot.x), (float)(-slot.y));
                        this.renderSlot(guiGraphics, slot, mouseX, mouseY);
                    } else {
                        guiGraphics.pose().translate((float)(customSlot.getWidth() - 18) / 2.0f, (float)(customSlot.getHeight() - 18) / 2.0f);
                        this.renderSlot(guiGraphics, slot, mouseX, mouseY);
                    }
                    guiGraphics.pose().popMatrix();
                }
                if (this.hoveredSlot != slot || !slot.isHighlightable()) continue;
                helper.submitSprite(AbstractContainerScreen.SLOT_HIGHLIGHT_FRONT_SPRITE, (float)(slot.x - 4), (float)(slot.y - 4), (float)(slotWidth + 6), (float)(slotHeight + 6));
                continue;
            }
            if (this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) {
                this.hoveredSlot = slot;
                helper.submitSprite(AbstractContainerScreen.SLOT_HIGHLIGHT_BACK_SPRITE, (float)(slot.x - 4), (float)(slot.y - 4), 24.0f, 24.0f);
            }
            this.renderSlot(guiGraphics, slot, mouseX, mouseY);
            if (this.hoveredSlot != slot) continue;
            helper.submitSprite(AbstractContainerScreen.SLOT_HIGHLIGHT_FRONT_SPRITE, (float)(slot.x - 4), (float)(slot.y - 4), 24.0f, 24.0f);
        }
        this.widget.renderForeground(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        guiGraphics.pose().popMatrix();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ForgeEventFactoryClient.onContainerRenderForeground((AbstractContainerScreen)this, (GuiGraphics)guiGraphics, (int)mouseX, (int)mouseY);
        this.renderCarriedItem(guiGraphics, mouseX, mouseY);
        this.renderSnapbackItem(guiGraphics);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        this.widget.renderOverlay(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        guiGraphics.pose().popMatrix();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        int mouseY;
        this.dragging = true;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mousePressed(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), isDoubleClick, false) || super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        int mouseY;
        this.dragging = false;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mouseReleased(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), false) || super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        int mouseY;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mouseDragged(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), deltaX, deltaY, false) || super.mouseDragged(event, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.height - this.widget.height()) / 2)), verticalAmount, false) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.widget.keyPressed(event, false)) {
            return true;
        }
        if (ClientUtils.getMinecraft().options.keyInventory.matches(event)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean keyReleased(KeyEvent event) {
        return this.widget.keyReleased(event, false) || super.keyReleased(event);
    }

    public boolean charTyped(CharacterEvent event) {
        return this.widget.charTyped((char)event.codepoint(), false) || super.charTyped(event);
    }

    public boolean isPauseScreen() {
        return this.isPauseScreen;
    }

    public Component getNarrationMessage() {
        Component message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

