/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;

public abstract class AdvancementGenerator
extends ResourceGenerator {
    private final Map<Identifier, AdvancementBuilder> advancements = new HashMap<Identifier, AdvancementBuilder>();

    public AdvancementGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        RegistryOps ops = ResourceGenerator.registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        for (AdvancementBuilder advancementBuilder : this.advancements.values()) {
            if (advancementBuilder.criteria.isEmpty()) {
                throw new RuntimeException("Advancement '" + String.valueOf(advancementBuilder.identifier) + "' does not have any criteria!");
            }
            if (advancementBuilder.requirements.isEmpty()) {
                if (advancementBuilder.criteria.size() != 1) {
                    throw new RuntimeException("Advancement '" + String.valueOf(advancementBuilder.identifier) + "' does not have any requirements set!");
                }
                advancementBuilder.requirements.add((String[])advancementBuilder.criteria.keySet().toArray(String[]::new));
            }
            for (String criterion2 : (String[])advancementBuilder.requirements.stream().flatMap(Arrays::stream).toArray(String[]::new)) {
                if (advancementBuilder.criteria.containsKey(criterion2)) continue;
                throw new RuntimeException("Found requirement for unknown criterion '" + criterion2 + "' in advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
            }
            JsonObject json = new JsonObject();
            if (!advancementBuilder.conditions.isEmpty()) {
                JsonArray conditionsJson = new JsonArray();
                for (ICondition condition : advancementBuilder.conditions) {
                    conditionsJson.add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)ops, (Object)condition).getOrThrow());
                }
                json.add("conditions", (JsonElement)conditionsJson);
            }
            if (advancementBuilder.parent != null) {
                Identifier parent = advancementBuilder.parent;
                if (!this.advancements.containsKey(parent) && !this.cache.doesResourceExist(ResourceType.DATA, parent.getNamespace(), "advancement", parent.getPath(), ".json")) {
                    throw new RuntimeException("Could not find parent '" + String.valueOf(parent) + "' for advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
                }
                json.addProperty("parent", parent.toString());
            }
            JsonObject displayJson = new JsonObject();
            if (advancementBuilder.icon == null && !RecipeBuilder.ROOT_RECIPE_ADVANCEMENT.equals((Object)advancementBuilder.parent)) {
                throw new RuntimeException("Advancement '" + String.valueOf(advancementBuilder.identifier) + "' must have an icon!");
            }
            if (advancementBuilder.icon != null) {
                JsonObject iconJson = new JsonObject();
                iconJson.addProperty("id", Registries.ITEMS.getIdentifier(advancementBuilder.icon).toString());
                if (advancementBuilder.iconComponents != null && !advancementBuilder.iconComponents.isEmpty()) {
                    iconJson.add("components", (JsonElement)DataComponentPatch.CODEC.encodeStart((DynamicOps)ops, (Object)advancementBuilder.iconComponents).getOrThrow());
                }
                displayJson.add("icon", (JsonElement)iconJson);
            }
            JsonObject titleJson = new JsonObject();
            titleJson.addProperty("translate", advancementBuilder.titleKey);
            displayJson.add("title", (JsonElement)titleJson);
            JsonObject description = new JsonObject();
            description.addProperty("translate", advancementBuilder.descriptionKey);
            displayJson.add("description", (JsonElement)description);
            displayJson.addProperty("frame", advancementBuilder.frame.getSerializedName());
            if (advancementBuilder.background != null) {
                if (!this.cache.doesResourceExist(ResourceType.ASSET, advancementBuilder.background.getNamespace(), "textures", advancementBuilder.background.getPath(), ".png")) {
                    throw new RuntimeException("Could not find background texture '" + String.valueOf(advancementBuilder.background) + "' for advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
                }
                displayJson.addProperty("background", advancementBuilder.background.getNamespace() + ":textures/" + advancementBuilder.background.getPath() + ".png");
            }
            displayJson.addProperty("show_toast", Boolean.valueOf(advancementBuilder.showToast));
            displayJson.addProperty("announce_to_chat", Boolean.valueOf(advancementBuilder.announceToChat));
            displayJson.addProperty("hidden", Boolean.valueOf(advancementBuilder.hidden));
            json.add("display", (JsonElement)displayJson);
            JsonObject criteriaJson = new JsonObject();
            for (Map.Entry<String, Pair<CriterionTrigger<?>, CriterionTriggerInstance>> entry : advancementBuilder.criteria.entrySet()) {
                JsonObject criterionJson = new JsonObject();
                criterionJson.addProperty("trigger", BuiltInRegistries.TRIGGER_TYPES.getKey(entry.getValue().left()).toString());
                JsonElement conditionsJson = (JsonElement)entry.getValue().left().codec().encodeStart((DynamicOps)ops, (Object)entry.getValue().right()).getOrThrow();
                if (!conditionsJson.isJsonObject() || !conditionsJson.getAsJsonObject().isEmpty()) {
                    criterionJson.add("conditions", conditionsJson);
                }
                criteriaJson.add(entry.getKey(), (JsonElement)criterionJson);
            }
            json.add("criteria", (JsonElement)criteriaJson);
            JsonArray requirementsArray = new JsonArray();
            for (String[] requirementGroup : advancementBuilder.requirements) {
                JsonArray groupArray = new JsonArray();
                Arrays.stream(requirementGroup).forEach(arg_0 -> ((JsonArray)groupArray).add(arg_0));
                requirementsArray.add((JsonElement)groupArray);
            }
            json.add("requirements", (JsonElement)requirementsArray);
            JsonObject jsonObject = new JsonObject();
            if (!advancementBuilder.rewardRecipes.isEmpty()) {
                JsonArray recipesJson = new JsonArray();
                for (Identifier rewardRecipe : advancementBuilder.rewardRecipes) {
                    if (!this.cache.doesResourceExist(ResourceType.DATA, rewardRecipe.getNamespace(), "recipe", rewardRecipe.getPath(), ".json")) {
                        throw new RuntimeException("Could not find reward recipe '" + String.valueOf(rewardRecipe) + "' for advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
                    }
                    recipesJson.add(rewardRecipe.toString());
                }
                jsonObject.add("recipes", (JsonElement)recipesJson);
            }
            if (!advancementBuilder.rewardLootTables.isEmpty()) {
                JsonArray lootTablesJson = new JsonArray();
                for (Identifier rewardLootTable : advancementBuilder.rewardLootTables) {
                    if (!this.cache.doesResourceExist(ResourceType.DATA, rewardLootTable.getNamespace(), "loot_tables", rewardLootTable.getPath(), ".json")) {
                        throw new RuntimeException("Could not find reward loot table '" + String.valueOf(rewardLootTable) + "' for advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
                    }
                    lootTablesJson.add(rewardLootTable.toString());
                }
                jsonObject.add("loot", (JsonElement)lootTablesJson);
            }
            if (advancementBuilder.rewardExperience != 0) {
                jsonObject.addProperty("experience", (Number)advancementBuilder.rewardExperience);
            }
            if (jsonObject.size() != 0) {
                json.add("rewards", (JsonElement)jsonObject);
            }
            Identifier identifier = advancementBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.DATA, json, identifier.getNamespace(), "advancement", identifier.getPath());
        }
    }

    public AdvancementBuilder advancement(Identifier identifier) {
        if (this.advancements.containsKey(identifier)) {
            throw new RuntimeException("Duplicate advancement with identifier '" + String.valueOf(identifier) + "'!");
        }
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.getNamespace(), "advancement", identifier.getPath(), ".json");
        return this.advancements.computeIfAbsent(identifier, i -> new AdvancementBuilder(this.modid, (Identifier)i));
    }

    public AdvancementBuilder advancement(String namespace, String path) {
        return this.advancement(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public AdvancementBuilder advancement(String identifier) {
        return this.advancement(this.modid, identifier);
    }

    @Override
    public String getName() {
        return this.modName + " Advancement Generator";
    }

    protected static class AdvancementBuilder {
        protected final String modid;
        protected final Identifier identifier;
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private final Map<String, Pair<CriterionTrigger<?>, CriterionTriggerInstance>> criteria = new LinkedHashMap();
        private final List<String[]> requirements = new ArrayList<String[]>();
        private final List<Identifier> rewardLootTables = new ArrayList<Identifier>();
        private final List<Identifier> rewardRecipes = new ArrayList<Identifier>();
        private Identifier parent;
        private Item icon;
        private DataComponentPatch iconComponents;
        private String titleKey;
        private String descriptionKey;
        private AdvancementType frame = AdvancementType.TASK;
        private Identifier background;
        private boolean showToast = true;
        private boolean announceToChat = true;
        private boolean hidden;
        private int rewardExperience;

        public AdvancementBuilder(String modid, Identifier identifier) {
            this.modid = modid;
            this.identifier = identifier;
            this.titleKey = identifier.getNamespace() + ".advancement." + identifier.getPath() + ".title";
            this.descriptionKey = identifier.getNamespace() + ".advancement." + identifier.getPath() + ".description";
        }

        public AdvancementBuilder condition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public AdvancementBuilder condition(ResourceCondition condition) {
            return this.condition(ResourceCondition.createForgeCondition(condition));
        }

        public AdvancementBuilder notCondition(ICondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public AdvancementBuilder notCondition(ResourceCondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public AdvancementBuilder modLoadedCondition(String modid) {
            return this.condition(new ModLoadedResourceCondition(modid));
        }

        public AdvancementBuilder parent(Identifier advancement) {
            if (this.identifier.equals((Object)advancement)) {
                throw new IllegalArgumentException("Advancement '" + String.valueOf(this.identifier) + "' cannot have itself as parent!");
            }
            this.parent = advancement;
            return this;
        }

        public AdvancementBuilder parent(String namespace, String path) {
            return this.parent(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
        }

        public AdvancementBuilder parent(String advancement) {
            return this.parent(this.modid, advancement);
        }

        public AdvancementBuilder icon(ItemLike item, DataComponentPatch components) {
            this.icon = item.asItem();
            this.iconComponents = components;
            return this;
        }

        public AdvancementBuilder icon(ItemLike item) {
            return this.icon(item, null);
        }

        public AdvancementBuilder icon(Identifier item) {
            if (!Registries.ITEMS.hasIdentifier(item)) {
                throw new IllegalArgumentException("Could not find any item registered under '" + String.valueOf(item) + "'!");
            }
            return this.icon((ItemLike)Registries.ITEMS.getValue(item), null);
        }

        public AdvancementBuilder icon(String namespace, String identifier) {
            return this.icon(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
        }

        public AdvancementBuilder title(String translationKey) {
            if (translationKey == null || translationKey.isBlank()) {
                throw new IllegalArgumentException("Title translation key '" + translationKey + "' for advancement '" + String.valueOf(this.identifier) + "' must not be empty!");
            }
            this.titleKey = translationKey;
            return this;
        }

        public AdvancementBuilder description(String translationKey) {
            if (translationKey == null || translationKey.isBlank()) {
                throw new IllegalArgumentException("Description translation key '" + translationKey + "' for advancement '" + String.valueOf(this.identifier) + "' must not be empty!");
            }
            this.descriptionKey = translationKey;
            return this;
        }

        public AdvancementBuilder frame(AdvancementType frameType) {
            this.frame = frameType;
            return this;
        }

        public AdvancementBuilder challengeFrame() {
            return this.frame(AdvancementType.CHALLENGE);
        }

        public AdvancementBuilder goalFrame() {
            return this.frame(AdvancementType.GOAL);
        }

        public AdvancementBuilder taskFrame() {
            return this.frame(AdvancementType.TASK);
        }

        public AdvancementBuilder background(Identifier texture) {
            this.background = texture;
            return this;
        }

        public AdvancementBuilder background(String namespace, String path) {
            return this.background(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
        }

        public AdvancementBuilder showToast(boolean show) {
            this.showToast = show;
            return this;
        }

        public AdvancementBuilder dontShowToast() {
            return this.showToast(false);
        }

        public AdvancementBuilder announceToChat(boolean announce) {
            this.announceToChat = announce;
            return this;
        }

        public AdvancementBuilder dontAnnounceToChat() {
            return this.announceToChat(false);
        }

        public AdvancementBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public AdvancementBuilder hidden() {
            return this.hidden(true);
        }

        public <T extends CriterionTriggerInstance> AdvancementBuilder criterion(String name, CriterionTrigger<T> criterion, T instance) {
            if (this.criteria.containsKey(name)) {
                throw new RuntimeException("Duplicate criterion with name '" + name + "' for advancement '" + String.valueOf(this.identifier) + "'!");
            }
            this.criteria.put(name, Pair.of(criterion, instance));
            return this;
        }

        public AdvancementBuilder criterion(String name, Criterion<?> criterion) {
            if (this.criteria.containsKey(name)) {
                throw new RuntimeException("Duplicate criterion with name '" + name + "' for advancement '" + String.valueOf(this.identifier) + "'!");
            }
            this.criteria.put(name, Pair.of(criterion.trigger(), criterion.triggerInstance()));
            return this;
        }

        public AdvancementBuilder hasItemsCriterion(String name, ItemLike ... items) {
            this.criterion(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
            return this;
        }

        public AdvancementBuilder requirementGroup(String ... criteria) {
            if (this.requirements.contains(criteria)) {
                throw new RuntimeException("Duplicate requirement group '" + Arrays.toString(criteria) + "' for advancement '" + String.valueOf(this.identifier) + "'!");
            }
            this.requirements.add(criteria);
            return this;
        }

        public AdvancementBuilder requirements(String[] ... groups) {
            Arrays.stream(groups).forEach(this::requirementGroup);
            return this;
        }

        public AdvancementBuilder rewardExperience(int experience) {
            if (experience < 0) {
                throw new IllegalArgumentException("Reward experience for advancement '" + String.valueOf(this.identifier) + "' must be greater than 0, not '" + experience + "'!");
            }
            this.rewardExperience = experience;
            return this;
        }

        public AdvancementBuilder rewardLootTable(Identifier lootTable) {
            this.rewardLootTables.add(lootTable);
            return this;
        }

        public AdvancementBuilder rewardLootTable(String namespace, String path) {
            return this.rewardLootTable(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
        }

        public AdvancementBuilder rewardRecipe(Identifier recipe) {
            if (this.rewardRecipes.contains(recipe)) {
                throw new RuntimeException("Duplicate recipe reward '" + String.valueOf(recipe) + "' for advancement '" + String.valueOf(this.identifier) + "'!");
            }
            this.rewardRecipes.add(recipe);
            return this;
        }

        public AdvancementBuilder rewardRecipe(String namespace, String path) {
            return this.rewardRecipe(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
        }
    }
}

