/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.resources.Identifier;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.IInventoryCommonModifiable;
import org.cyclops.cyclopscore.inventory.IInventoryLocation;
import org.cyclops.cyclopscore.inventory.InventoryModifiableContainer;
import org.cyclops.cyclopscore.inventory.ItemLocation;

public class InventoryLocationPlayer
implements IInventoryLocation {
    private static InventoryLocationPlayer INSTANCE = new InventoryLocationPlayer();

    public static InventoryLocationPlayer getInstance() {
        return INSTANCE;
    }

    private InventoryLocationPlayer() {
    }

    @Override
    public Identifier getUniqueName() {
        return Identifier.fromNamespaceAndPath((String)"cyclopscore", (String)"player");
    }

    @Override
    public IInventoryCommonModifiable getInventory(Player player) {
        return new InventoryModifiableContainer((Container)player.getInventory());
    }

    @Override
    public ItemStack getItemInSlot(Player player, int slot) {
        return player.getInventory().getItem(slot);
    }

    @Override
    public void setItemInSlot(Player player, int slot, ItemStack itemStack) {
        player.getInventory().setItem(slot, itemStack);
    }

    public ItemLocation handToLocation(Player player, InteractionHand hand, int selectedSlot) {
        int slot = hand == InteractionHand.MAIN_HAND ? selectedSlot : 40;
        return new ItemLocation(this, slot);
    }
}

