/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.GuiHelpersCommon;
import org.cyclops.cyclopscore.helper.IGuiHelpersForge;
import org.cyclops.cyclopscore.helper.IModHelpersForge;

public class GuiHelpersForge
extends GuiHelpersCommon
implements IGuiHelpersForge {
    public GuiHelpersForge(IModHelpersForge modHelpers) {
        super(modHelpers);
    }

    @Override
    public void renderFluidTank(GuiGraphics gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height) {
        if (fluidStack != null && !fluidStack.isEmpty() && capacity > 0) {
            gui.pose().pushMatrix();
            int level = (int)((double)height * ((double)fluidStack.getAmount() / (double)capacity));
            TextureAtlasSprite icon = ((IModHelpersForge)this.modHelpers).getRenderHelpers().getFluidIcon(fluidStack, Direction.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((FluidType)fluidStack.getFluid().getFluidType());
                Triple colorParts = this.modHelpers.getBaseHelpers().intToRGB(renderProperties.getTintColor(fluidStack));
                if (fluidStack.getFluid() == Fluids.WATER || fluidStack.getFluid() == Fluids.FLOWING_WATER) {
                    colorParts = Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.335f), (Object)Float.valueOf(1.0f));
                }
                gui.blitSprite(RenderPipelines.GUI_OPAQUE_TEXTURED_BACKGROUND, icon, x, y - textureHeight - verticalOffset + height, width, textureHeight, ARGB.colorFromFloat((float)1.0f, (float)((Float)colorParts.getLeft()).floatValue(), (float)((Float)colorParts.getMiddle()).floatValue(), (float)((Float)colorParts.getRight()).floatValue()));
                verticalOffset += 16;
            }
            gui.pose().popMatrix();
        }
    }

    @Override
    public void renderFluidSlot(GuiGraphics gui, @Nullable FluidStack fluidStack, int x, int y) {
        if (fluidStack != null) {
            this.renderFluidTank(gui, fluidStack, fluidStack.getAmount(), x, y, this.getSlotSizeInner(), this.getSlotSizeInner());
        }
    }

    @Override
    public void renderOverlayedFluidTank(GuiGraphics gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height, Identifier textureOverlay, int overlayTextureX, int overlayTextureY) {
        this.renderFluidTank(gui, fluidStack, capacity, x, y, width, height);
        if (fluidStack != null && capacity > 0) {
            gui.blit(RenderPipelines.GUI_OPAQUE_TEXTURED_BACKGROUND, textureOverlay, x, y, (float)overlayTextureX, (float)overlayTextureY, width, height, 256, 256);
        }
    }
}

