/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.gametest;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;

public class MethodGameTestInstance
extends GameTestInstance {
    public static final MapCodec<? extends GameTestInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TestData.CODEC.forGetter(rec$ -> ((MethodGameTestInstance)((Object)((Object)((Object)rec$)))).info()), (App)Codec.STRING.fieldOf("modId").forGetter(MethodGameTestInstance::getModId), (App)Codec.STRING.fieldOf("class").forGetter(MethodGameTestInstance::getClassName), (App)Codec.STRING.fieldOf("method").forGetter(MethodGameTestInstance::getMethodName)).apply((Applicative)instance, MethodGameTestInstance::new));
    private final String modId;
    private final String className;
    private final String methodName;

    public MethodGameTestInstance(TestData<Holder<TestEnvironmentDefinition>> info, String modId, String className, String methodName) {
        super(info);
        this.modId = modId;
        this.className = className;
        this.methodName = methodName;
    }

    public String getModId() {
        return this.modId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void run(GameTestHelper gameTestHelper) {
        try {
            Class<?> clazz = Class.forName(this.className);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod(this.methodName, GameTestHelper.class);
            method.invoke(instance, gameTestHelper);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new GameTestAssertException((Component)Component.literal((String)e.getMessage()), (int)gameTestHelper.getTick());
        }
    }

    public MapCodec<? extends GameTestInstance> codec() {
        return CODEC;
    }

    protected MutableComponent typeDescription() {
        return Component.literal((String)("Method-based test instance for " + this.getClassName() + "." + this.getMethodName()));
    }

    public Identifier getId() {
        return Identifier.fromNamespaceAndPath((String)this.modId, (String)(this.className.replaceAll("org.cyclops\\.[^.]*\\.[^.]*\\.", "") + "." + this.methodName).toLowerCase(Locale.ROOT).replace('.', '_'));
    }
}

