/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import org.cyclops.cyclopscore.config.ConfigurableTypeCommon;
import org.cyclops.cyclopscore.config.extendedconfig.EntityClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;

public abstract class EntityConfigCommon<M extends IModBase, T extends Entity>
extends ExtendedConfigRegistry<EntityConfigCommon<M, T>, EntityType<T>, M> {
    @Nullable
    private ItemConfigCommon<M> spawnEggItemConfig;
    private EntityClientConfig<M, T> clientConfig;

    public EntityConfigCommon(M mod, String namedId, Function<EntityConfigCommon<M, T>, EntityType.Builder<T>> elementConstructor) {
        this(mod, namedId, elementConstructor, null);
    }

    public EntityConfigCommon(M mod, String namedId, Function<EntityConfigCommon<M, T>, EntityType.Builder<T>> elementConstructor, @Nullable BiFunction<EntityConfigCommon<M, T>, Supplier<EntityType<T>>, ItemConfigCommon<M>> spawnEggItemConstructor) {
        super(mod, namedId, elementConstructor.andThen(builder -> builder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)mod.getModId(), (String)namedId)))));
        if (spawnEggItemConstructor != null) {
            mod.getConfigHandler().addConfigurable((ExtendedConfigCommon)spawnEggItemConstructor.apply(this, this::getInstance));
        }
    }

    public static <M extends IModBase, T extends Mob> BiFunction<EntityConfigCommon<M, T>, Supplier<EntityType<T>>, ItemConfigCommon<M>> getDefaultSpawnEggItemConfigConstructor(M mod, String itemName) {
        return EntityConfigCommon.getDefaultSpawnEggItemConfigConstructor(mod, itemName, null);
    }

    public static <M extends IModBase, T extends Mob> BiFunction<EntityConfigCommon<M, T>, Supplier<EntityType<T>>, ItemConfigCommon<M>> getDefaultSpawnEggItemConfigConstructor(M mod, String itemName, @Nullable Function<Item.Properties, Item.Properties> itemPropertiesModifier) {
        return (entityConfig, entityType) -> {
            ItemConfigCommon<IModBase> itemConfig = new ItemConfigCommon<IModBase>(mod, itemName, (arg_0, arg_1) -> EntityConfigCommon.lambda$getDefaultSpawnEggItemConfigConstructor$1(itemPropertiesModifier, (Supplier)entityType, arg_0, arg_1));
            entityConfig.setSpawnEggItemConfig(itemConfig);
            return itemConfig;
        };
    }

    @Override
    public String getTranslationKey() {
        return "entity." + this.getNamedId();
    }

    @Override
    public ConfigurableTypeCommon getConfigurableType() {
        return ConfigurableTypeCommon.ENTITY;
    }

    public abstract EntityClientConfig<M, T> constructEntityClientConfig();

    public final EntityClientConfig<M, T> getEntityClientConfig() {
        if (this.getMod().getModHelpers().getMinecraftHelpers().isClientSide()) {
            if (this.clientConfig == null) {
                this.clientConfig = this.constructEntityClientConfig();
            }
            return this.clientConfig;
        }
        return null;
    }

    @Override
    public Registry<? super EntityType<T>> getRegistry() {
        return BuiltInRegistries.ENTITY_TYPE;
    }

    public void setSpawnEggItemConfig(@Nullable ItemConfigCommon spawnEggItemConfig) {
        this.spawnEggItemConfig = spawnEggItemConfig;
    }

    private static /* synthetic */ Item lambda$getDefaultSpawnEggItemConfigConstructor$1(Function itemPropertiesModifier, Supplier entityType, ItemConfigCommon itemConfigSub, Item.Properties properties) {
        if (itemPropertiesModifier != null) {
            properties = (Item.Properties)itemPropertiesModifier.apply(properties);
        }
        return new SpawnEggItem(properties.spawnEgg((EntityType)entityType.get()));
    }
}

