/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.resources.Identifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import org.cyclops.cyclopscore.client.model.IDynamicModelElementCommon;
import org.cyclops.cyclopscore.config.configurabletypeaction.ItemAction;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.ModBaseForge;

public class ItemActionForge<M extends ModBaseForge<M>>
extends ItemAction<M> {
    public ItemActionForge(M mod) {
        if (((ModBaseForge)mod).getModHelpers().getMinecraftHelpers().isClientSide()) {
            ModelEvent.RegisterModelStateDefinitions.BUS.addListener(ItemActionForge::onModelRegistryLoad);
            ModelEvent.ModifyBakingResult.BUS.addListener(ItemActionForge::onModelBakeEvent);
        }
    }

    @Override
    protected void polish(ItemConfigCommon<M> config) {
        IDynamicModelElementCommon dynamicModelElement;
        super.polish(config);
        if (((ModBaseForge)config.getMod()).getModHelpers().getMinecraftHelpers().isClientSide() && (dynamicModelElement = config.getItemClientConfig().getDynamicModelElement()) != null) {
            ItemAction.handleItemModel(config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistryLoad(ModelEvent.RegisterModelStateDefinitions event) {
        for (ItemConfigCommon config : MODEL_ENTRIES) {
            config.getItemClientConfig().dynamicItemVariantLocation = config.getItemClientConfig().registerDynamicModel();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (ItemConfigCommon config : MODEL_ENTRIES) {
            IDynamicModelElementCommon dynamicModelElement = config.getItemClientConfig().getDynamicModelElement();
            if (config.getItemClientConfig().dynamicItemVariantLocation == null) continue;
            event.getResults().itemStackModels().put(config.getItemClientConfig().dynamicItemVariantLocation, dynamicModelElement.createDynamicItemModel(pair -> event.getResults().itemStackModels().put((Identifier)pair.getLeft(), (ItemModel)pair.getRight()), key -> (ItemModel)event.getResults().itemStackModels().get(key)));
        }
    }
}

