/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElementCommon;
import org.cyclops.cyclopscore.config.configurabletypeaction.BlockAction;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.ModBaseForge;

public class BlockActionForge<M extends ModBaseForge<M>>
extends BlockAction<M> {
    public BlockActionForge(M mod) {
        if (((ModBaseForge)mod).getModHelpers().getMinecraftHelpers().isClientSide()) {
            ModelEvent.RegisterModelStateDefinitions.BUS.addListener(BlockActionForge::onModelRegistryLoad);
            ModelEvent.ModifyBakingResult.BUS.addListener(BlockActionForge::onModelBakeEvent);
            RegisterColorHandlersEvent.Block.BUS.addListener(BlockActionForge::onRegisterColorHandlers);
        }
    }

    @Override
    protected void polish(BlockConfigCommon<M> config) {
        IDynamicModelElementCommon dynamicModelElement;
        super.polish(config);
        if (((ModBaseForge)config.getMod()).getModHelpers().getMinecraftHelpers().isClientSide() && (dynamicModelElement = config.getBlockClientConfig().getDynamicModelElement()) != null) {
            BlockAction.handleDynamicBlockModel(config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistryLoad(ModelEvent.RegisterModelStateDefinitions event) {
        for (BlockConfigCommon config : MODEL_ENTRIES) {
            Pair<BlockState, Identifier> resourceLocations = config.getBlockClientConfig().registerDynamicModel();
            config.getBlockClientConfig().dynamicBlockVariantLocation = (BlockState)resourceLocations.getLeft();
            config.getBlockClientConfig().dynamicItemVariantLocation = (Identifier)resourceLocations.getRight();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (BlockConfigCommon config : MODEL_ENTRIES) {
            IDynamicModelElementCommon dynamicModelElement = config.getBlockClientConfig().getDynamicModelElement();
            BlockStateModel dynamicBlockModel = dynamicModelElement.createDynamicBlockModel(pair -> event.getResults().blockStateModels().put((BlockState)pair.getLeft(), (BlockStateModel)pair.getRight()), key -> (BlockStateModel)event.getResults().blockStateModels().get(key));
            ItemModel dynamicItemModel = dynamicModelElement.createDynamicItemModel(pair -> event.getResults().itemStackModels().put((Identifier)pair.getLeft(), (ItemModel)pair.getRight()), key -> (ItemModel)event.getResults().itemStackModels().get(key));
            if (config.getBlockClientConfig().dynamicBlockVariantLocation != null) {
                event.getResults().blockStateModels().put(config.getBlockClientConfig().dynamicBlockVariantLocation, dynamicBlockModel);
            }
            if (config.getBlockClientConfig().dynamicItemVariantLocation == null) continue;
            event.getResults().itemStackModels().put(config.getBlockClientConfig().dynamicItemVariantLocation, dynamicItemModel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <M extends ModBaseForge> void onRegisterColorHandlers(RegisterColorHandlersEvent.Block event) {
        for (BlockConfigCommon blockConfig : COLOR_ENTRIES) {
            event.register(blockConfig.getBlockClientConfig().getBlockColorHandler(), new Block[]{(Block)blockConfig.getInstance()});
        }
    }
}

