/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.world.entity.Entity;

public class CommandIgnite
implements Command<CommandSourceStack> {
    private final boolean durationParam;

    public CommandIgnite(boolean durationParam) {
        this.durationParam = durationParam;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection entities = EntityArgument.getEntities(context, (String)"targets");
        int duration = this.durationParam ? IntegerArgumentType.getInteger(context, (String)"duration") : 2;
        for (Entity entity : entities) {
            entity.setRemainingFireTicks(duration);
            ((CommandSourceStack)context.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"chat.cyclopscore.command.ignitedPlayer", (Object[])new Object[]{entity.getDisplayName(), duration}));
        }
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ignite").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes((Command)new CommandIgnite(false))).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer()).executes((Command)new CommandIgnite(true))));
    }
}

