/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.image.Images;

public class WidgetTextFieldExtended
extends EditBox {
    private final boolean background;
    private IInputListener listener;

    public WidgetTextFieldExtended(Font fontrenderer, int x, int y, int width, int height, Component narrationMessage, boolean background) {
        super(fontrenderer, x, y, width, height, narrationMessage);
        this.background = background;
    }

    public WidgetTextFieldExtended(Font fontrenderer, int x, int y, int width, int height, Component narrationMessage) {
        this(fontrenderer, x, y, width, height, narrationMessage, false);
    }

    public void setListener(IInputListener listener) {
        this.listener = listener;
    }

    public int getInnerWidth() {
        return this.width - 7;
    }

    protected void drawBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.setX(this.getX() - 1);
        this.setY(this.getY() - 1);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Images.WIDGETS, this.getX(), this.getY(), 0.0f, 0.0f, this.width / 2, this.height / 2, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Images.WIDGETS, this.getX() + this.width / 2, this.getY(), (float)(200 - this.width / 2), 0.0f, this.width / 2, this.height / 2, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Images.WIDGETS, this.getX(), this.getY() + this.height / 2, 0.0f, (float)(20 - this.height / 2), this.width / 2, this.height / 2, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Images.WIDGETS, this.getX() + this.width / 2, this.getY() + this.height / 2, (float)(200 - this.width / 2), (float)(20 - this.height / 2), this.width / 2, this.height / 2, 256, 256);
        this.setX(this.getX() + 1);
        this.setY(this.getY() + 1);
    }

    public void setValue(String value) {
        super.setValue(value);
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.background) {
            this.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        if (event.button() == 1 && event.x() >= (double)this.getX() && event.x() < (double)(this.getX() + this.width) && event.y() >= (double)this.getY() && event.y() < (double)(this.getY() + this.height)) {
            this.setFocused(true);
            this.moveCursorTo(0, true);
            this.setHighlightPos(Integer.MAX_VALUE);
            return true;
        }
        if (super.mouseClicked(event, isDoubleClick)) {
            this.setFocused(true);
            return true;
        }
        this.setFocused(false);
        return false;
    }
}

