/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.button;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;

public class ButtonCheckbox
extends Button {
    private boolean checked;

    public ButtonCheckbox(int x, int y, int width, int height, Component title, Button.OnPress pressedAction) {
        super(x, y, width, height, title, pressedAction, DEFAULT_NARRATION);
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void onPress(InputWithModifiers input) {
        this.setChecked(!this.isChecked());
        super.onPress(input);
    }

    public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int i = 0;
            if (this.isChecked()) {
                i = 2;
            } else if (this.isHovered) {
                i = 1;
            }
            Image image = Images.CHECKBOX[i];
            int imageWidth = image.getWidth();
            int imageWHeight = image.getHeight();
            int x = this.width <= imageWidth ? this.getX() : this.getX() + (this.width - imageWidth) / 2;
            int y = this.height <= imageWHeight ? this.getY() : this.getY() + (this.height - imageWHeight) / 2;
            image.draw(guiGraphics, x, y);
        }
    }
}

