/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FileUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;

public class GuiMainMenuExtensionDevWorld {
    private static final String WORLD_NAME_PREFIX = "cyclops-dev";

    public static void onMainMenuInit(Minecraft minecraft, Screen screen) {
        if (screen instanceof TitleScreen) {
            Button buttonBuilt = Button.builder((Component)Component.translatable((String)"general.cyclopscore.dev_world"), button -> {
                String saveName;
                Minecraft mc = Minecraft.getInstance();
                if (!Minecraft.getInstance().hasShiftDown()) {
                    LevelSummary devWorldSummary = null;
                    mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    try {
                        List levelList = (List)((CompletableFuture)mc.getLevelSource().loadLevelSummaries(mc.getLevelSource().findLevelCandidates()).exceptionally(p_233202_ -> {
                            mc.delayCrash(CrashReport.forThrowable((Throwable)p_233202_, (String)"Couldn't load level list"));
                            return List.of();
                        })).get(5000L, TimeUnit.MILLISECONDS);
                        for (LevelSummary worldSummary : levelList) {
                            if (!worldSummary.getLevelName().equals(WORLD_NAME_PREFIX) || devWorldSummary != null && devWorldSummary.getLastPlayed() >= worldSummary.getLastPlayed()) continue;
                            devWorldSummary = worldSummary;
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException | LevelStorageException e) {
                        CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.ERROR, "Couldn't load level list" + e.getMessage());
                        mc.setScreen((Screen)new ErrorScreen((Component)Component.translatable((String)"selectWorld.unable_to_load"), (Component)Component.literal((String)e.getMessage())));
                    }
                    if (devWorldSummary != null && mc.getLevelSource().levelExists(devWorldSummary.getLevelId())) {
                        mc.setScreenAndShow((Screen)new GenericMessageScreen((Component)Component.translatable((String)"selectWorld.data_read")));
                        mc.createWorldOpenFlows().openWorld(devWorldSummary.getLevelId(), () -> minecraft.setScreen(screen));
                        return;
                    }
                }
                GameRules gameRules = new GameRules(FeatureFlags.DEFAULT_FLAGS);
                gameRules.set(GameRules.ADVANCE_TIME, (Object)false, null);
                gameRules.set(GameRules.ADVANCE_WEATHER, (Object)false, null);
                gameRules.set(GameRules.IMMEDIATE_RESPAWN, (Object)true, null);
                gameRules.set(GameRules.SPAWN_PATROLS, (Object)false, null);
                gameRules.set(GameRules.SPAWN_WANDERING_TRADERS, (Object)false, null);
                WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(new DataPackConfig(new ArrayList(Minecraft.getInstance().getResourcePackRepository().getAvailableIds()), List.of()), FeatureFlags.REGISTRY.allFlags());
                LevelSettings worldsettings = new LevelSettings(WORLD_NAME_PREFIX, GameType.CREATIVE, false, Difficulty.PEACEFUL, true, gameRules, worlddataconfiguration);
                Function<HolderLookup.Provider, WorldDimensions> generatorSettings = registryAccess -> ((WorldPreset)registryAccess.lookupOrThrow(Registries.WORLD_PRESET).getOrThrow(WorldPresets.FLAT).value()).createWorldDimensions();
                long seed = new Random().nextLong();
                WorldOptions worldOptions = new WorldOptions(seed, false, false);
                try {
                    saveName = FileUtil.findAvailableName((Path)mc.getLevelSource().getBaseDir(), (String)WORLD_NAME_PREFIX, (String)"");
                }
                catch (IOException e) {
                    saveName = "World";
                }
                mc.createWorldOpenFlows().createFreshLevel(saveName, worldsettings, worldOptions, generatorSettings, screen);
            }).pos(screen.width / 2 + 102, screen.height / 4 + 48).size(58, 20).build();
            screen.addRenderableWidget((GuiEventListener)buttonBuilt);
        }
    }
}

