/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.blockentity.IBlockEntityDelayedTickable;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class BlockEntityTickerDelayed<T extends BlockEntity>
implements BlockEntityTicker<T> {
    public final void tick(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
        this.update(level, pos, blockState, blockEntity);
        this.trySendActualUpdate(level, pos, blockEntity);
    }

    protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
    }

    private void trySendActualUpdate(Level level, BlockPos pos, T blockEntity) {
        ((IBlockEntityDelayedTickable)blockEntity).reduceUpdateBackoff();
        if (((IBlockEntityDelayedTickable)blockEntity).getUpdateBackoff() <= 0) {
            ((IBlockEntityDelayedTickable)blockEntity).setUpdateBackoff(((IBlockEntityDelayedTickable)blockEntity).getUpdateBackoffTicks());
            if (((IBlockEntityDelayedTickable)blockEntity).shouldSendUpdate()) {
                ((IBlockEntityDelayedTickable)blockEntity).unsetSendUpdate();
                this.beforeSendUpdate();
                this.onSendUpdate(level, pos);
                this.afterSendUpdate();
            }
        }
    }

    protected void onSendUpdate(Level level, BlockPos pos) {
        IModHelpers.get().getBlockHelpers().markForUpdate(level, pos);
    }

    protected void beforeSendUpdate() {
    }

    protected void afterSendUpdate() {
    }
}

