/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.fabric.callbacks;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1937;

public final class CollectiveEntityEvents {
    public static final Event<Living_Tick> LIVING_TICK = EventFactory.createArrayBacked(Living_Tick.class, callbacks -> (world, entity) -> {
        for (Living_Tick callback : callbacks) {
            callback.onTick(world, entity);
        }
    });
    public static final Event<Living_Entity_Death> LIVING_ENTITY_DEATH = EventFactory.createArrayBacked(Living_Entity_Death.class, callbacks -> (world, entity, source) -> {
        for (Living_Entity_Death callback : callbacks) {
            if (callback.onDeath(world, entity, source)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Pre_Entity_Join_World> PRE_ENTITY_JOIN_WORLD = EventFactory.createArrayBacked(Pre_Entity_Join_World.class, callbacks -> (world, entity) -> {
        for (Pre_Entity_Join_World callback : callbacks) {
            if (callback.onPreSpawn(world, entity)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Entity_Fall_Damage_Calc> ON_FALL_DAMAGE_CALC = EventFactory.createArrayBacked(Entity_Fall_Damage_Calc.class, callbacks -> (world, entity, f, g) -> {
        for (Entity_Fall_Damage_Calc callback : callbacks) {
            if (callback.onFallDamageCalc(world, entity, f, g) != 0) continue;
            return 0;
        }
        return 1;
    });
    public static final Event<Entity_Living_Damage> ON_LIVING_DAMAGE_CALC = EventFactory.createArrayBacked(Entity_Living_Damage.class, callbacks -> (world, entity, damageSource, damageAmount) -> {
        for (Entity_Living_Damage callback : callbacks) {
            float newDamage = callback.onLivingDamageCalc(world, entity, damageSource, damageAmount);
            if (newDamage == damageAmount) continue;
            return newDamage;
        }
        return -1.0f;
    });
    public static final Event<Entity_Living_Attack> ON_LIVING_ATTACK = EventFactory.createArrayBacked(Entity_Living_Attack.class, callbacks -> (world, entity, damageSource, damageAmount) -> {
        for (Entity_Living_Attack callback : callbacks) {
            if (callback.onLivingAttack(world, entity, damageSource, damageAmount)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Entity_Is_Dropping_Loot> ON_ENTITY_IS_DROPPING_LOOT = EventFactory.createArrayBacked(Entity_Is_Dropping_Loot.class, callbacks -> (world, entity, damageSource) -> {
        for (Entity_Is_Dropping_Loot callback : callbacks) {
            callback.onDroppingLoot(world, entity, damageSource);
        }
    });
    public static final Event<Entity_Is_Jumping> ON_ENTITY_IS_JUMPING = EventFactory.createArrayBacked(Entity_Is_Jumping.class, callbacks -> (world, entity) -> {
        for (Entity_Is_Jumping callback : callbacks) {
            callback.onLivingJump(world, entity);
        }
    });
    public static final Event<Entity_On_Teleport_Command> ON_ENTITY_TELEPORT_COMMAND = EventFactory.createArrayBacked(Entity_On_Teleport_Command.class, callbacks -> (world, entity, targetX, targetY, targetZ) -> {
        for (Entity_On_Teleport_Command callback : callbacks) {
            if (callback.onTeleportCommand(world, entity, targetX, targetY, targetZ)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Entity_On_Lightning_Strike> ON_ENTITY_LIGHTNING_STRIKE = EventFactory.createArrayBacked(Entity_On_Lightning_Strike.class, callbacks -> (world, entity, lightningBolt) -> {
        for (Entity_On_Lightning_Strike callback : callbacks) {
            if (callback.onLightningStrike(world, entity, lightningBolt)) continue;
            return false;
        }
        return true;
    });

    private CollectiveEntityEvents() {
    }

    @FunctionalInterface
    public static interface Entity_On_Lightning_Strike {
        public boolean onLightningStrike(class_1937 var1, class_1297 var2, class_1538 var3);
    }

    @FunctionalInterface
    public static interface Entity_On_Teleport_Command {
        public boolean onTeleportCommand(class_1937 var1, class_1297 var2, double var3, double var5, double var7);
    }

    @FunctionalInterface
    public static interface Entity_Is_Jumping {
        public void onLivingJump(class_1937 var1, class_1297 var2);
    }

    @FunctionalInterface
    public static interface Entity_Is_Dropping_Loot {
        public void onDroppingLoot(class_1937 var1, class_1297 var2, class_1282 var3);
    }

    @FunctionalInterface
    public static interface Entity_Living_Attack {
        public boolean onLivingAttack(class_1937 var1, class_1297 var2, class_1282 var3, float var4);
    }

    @FunctionalInterface
    public static interface Entity_Living_Damage {
        public float onLivingDamageCalc(class_1937 var1, class_1297 var2, class_1282 var3, float var4);
    }

    @FunctionalInterface
    public static interface Entity_Fall_Damage_Calc {
        public int onFallDamageCalc(class_1937 var1, class_1297 var2, double var3, float var5);
    }

    @FunctionalInterface
    public static interface Pre_Entity_Join_World {
        public boolean onPreSpawn(class_1937 var1, class_1297 var2);
    }

    @FunctionalInterface
    public static interface Living_Entity_Death {
        public boolean onDeath(class_1937 var1, class_1297 var2, class_1282 var3);
    }

    @FunctionalInterface
    public static interface Living_Tick {
        public void onTick(class_1937 var1, class_1297 var2);
    }
}

