/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common.wrapper;

import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.forge.FallingTree;
import fr.rakambda.fallingtree.forge.common.wrapper.ItemWrapper;
import fr.rakambda.fallingtree.forge.compat.TetraCompat;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ToolActions;
import org.jspecify.annotations.NonNull;

public class ItemStackWrapper
implements IItemStack {
    private final @NonNull ItemStack raw;

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public boolean isDamageable() {
        return this.raw.isDamageableItem();
    }

    @Override
    public int getDamage() {
        return this.raw.getDamageValue();
    }

    @Override
    public int getMaxDamage() {
        return this.raw.getMaxDamage();
    }

    @Override
    public void damage(int amount, @NonNull IPlayer player) {
        this.raw.hurtAndBreak(amount, (LivingEntity)((Player)player.getRaw()), EquipmentSlot.MAINHAND);
        TetraCompat.tickHoningProgression(this, player);
    }

    @Override
    public @NonNull IItem getItem() {
        return new ItemWrapper(this.raw.getItem());
    }

    @Override
    public boolean hasChopperEnchant() {
        return EnchantmentHelper.hasTag((ItemStack)this.raw, FallingTree.getMod().getChopperEnchantmentTag());
    }

    @Override
    public Optional<BreakMode> getBreakModeFromEnchant() {
        if (!this.hasChopperEnchant()) {
            return Optional.empty();
        }
        Map<BreakMode, TagKey<Enchantment>> tags = FallingTree.getMod().getBreakModeChopperEnchantmentTag();
        for (BreakMode breakMode : tags.keySet()) {
            if (!EnchantmentHelper.hasTag((ItemStack)this.raw, tags.get((Object)breakMode))) continue;
            return Optional.of(breakMode);
        }
        return Optional.empty();
    }

    @Override
    public boolean canPerformAxeAction() {
        return this.raw.canPerformAction(ToolActions.AXE_DIG);
    }

    @Generated
    public ItemStackWrapper(@NonNull ItemStack raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    @Generated
    public String toString() {
        return "ItemStackWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @Generated
    public @NonNull ItemStack getRaw() {
        return this.raw;
    }
}

