/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.breaking;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.IBreakAttemptResult;
import fr.rakambda.fallingtree.common.tree.SuccessResult;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooSmallException;
import fr.rakambda.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.LeafForceBreaker;
import fr.rakambda.fallingtree.common.tree.breaking.LootHandler;
import fr.rakambda.fallingtree.common.tree.breaking.ToolDamageHandler;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;

public class FallingAnimationTreeBreakingHandler
implements ITreeBreakingHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(FallingAnimationTreeBreakingHandler.class);
    private static final Map<Map.Entry<Boolean, Boolean>, FallingAnimationTreeBreakingHandler> INSTANCE = new ConcurrentHashMap<Map.Entry<Boolean, Boolean>, FallingAnimationTreeBreakingHandler>();
    private final FallingTreeCommon<?> mod;
    private final boolean dropLogsAsItems;
    private final boolean dropLeavesAsItems;
    private final LeafForceBreaker leafForceBreaker;

    @Override
    public @NonNull IBreakAttemptResult breakTree(boolean isCancellable, @NonNull IPlayer player, @NonNull Tree tree) throws BreakTreeTooBigException, BreakTreeTooSmallException {
        IItemStack tool = player.getMainHandItem();
        ILevel level = tree.getLevel();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, this.mod.getConfiguration().getTools().getDamageMultiplicand(), this.mod.getConfiguration().getTools().getDurabilityMode(), tree.getBreakableCount(), this.mod.getConfiguration().getTrees().getMinSize(), this.mod.getConfiguration().getTrees().getMaxSize(), this.mod.getConfiguration().getTrees().getMaxSizeAction(), this.mod.getConfiguration().getTools().getDamageRounding());
        if (toolHandler.isPreserveTool()) {
            log.info("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.prevented_break_tool", new Object[0]));
            return SuccessResult.DO_NOT_CANCEL;
        }
        LinkedList scannedLeaves = new LinkedList();
        int wantToBreakCount = Math.min(tree.getBreakableCount(), toolHandler.getMaxBreakCount());
        LootHandler lootHandler = new LootHandler(wantToBreakCount, this.mod.getConfiguration().getTrees().getTrunkLootPercentage());
        int brokenCount = tree.getParts().stream().sorted(this.mod.getConfiguration().getTrees().getBreakOrder().getComparator()).limit(wantToBreakCount).mapToInt(part -> {
            IBlockPos logBlockPos = part.blockPos();
            IBlockState logState = level.getBlockState(logBlockPos);
            if (!tree.getHitPos().equals(logBlockPos) && !this.mod.checkCanBreakBlock(level, logBlockPos, logState, player)) {
                return 0;
            }
            player.awardItemUsed(tool.getItem());
            if (this.dropLogsAsItems && (!player.isCreative() || this.mod.getConfiguration().isLootInCreative())) {
                logState.getBlock().playerDestroy(level, player, logBlockPos, logState, level.getBlockEntity(logBlockPos), tool, !part.treePartType().isIncludeInTree() || lootHandler.breakNewTrunk());
            }
            level.fallBlock(logBlockPos, !this.dropLogsAsItems, 0.0, 0.5, 0.0, (level.getRandom().nextDouble() - 0.5) * 0.4, 0.0, (level.getRandom().nextDouble() - 0.5) * 0.4);
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.below());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.north());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.east());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.south());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.west());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.above());
            boolean isRemoved = level.removeBlock(logBlockPos, false);
            return part.treePartType().isBreakable() && isRemoved ? 1 : 0;
        }).sum();
        int toolDamage = toolHandler.getActualDamage(brokenCount) - 1;
        if (toolDamage > 0) {
            tool.damage(toolDamage, player);
        }
        if (brokenCount >= wantToBreakCount) {
            this.leafForceBreaker.forceBreakDecayLeaves(player, tree, level);
        }
        if (player.isCreative() && this.mod.getConfiguration().isLootInCreative()) {
            tree.getStart().ifPresent(part -> part.blockState().getBlock().playerDestroy(level, player, tree.getHitPos(), part.blockState(), part.blockEntity(), tool, lootHandler.breakNewTrunk()));
        }
        return SuccessResult.DO_NOT_CANCEL;
    }

    private void fallLeaf(LinkedList<IBlockPos> scannedLeaves, @NonNull IPlayer player, @NonNull ILevel level, int distance, @NonNull IBlockPos blockPos) {
        if (!this.mod.getConfiguration().getTrees().isLeavesBreaking()) {
            return;
        }
        if (distance == 0) {
            return;
        }
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.below());
        if (scannedLeaves.contains(blockPos)) {
            return;
        }
        scannedLeaves.add(blockPos);
        IBlockState blockState = level.getBlockState(blockPos);
        if (!this.mod.isLeafBlock(blockState.getBlock())) {
            return;
        }
        if (this.dropLeavesAsItems && (!player.isCreative() || this.mod.getConfiguration().isLootInCreative())) {
            blockState.getBlock().playerDestroy(level, player, blockPos, blockState, level.getBlockEntity(blockPos), this.mod.getEmptyItemStack(), true);
        }
        level.fallBlock(blockPos, !this.dropLeavesAsItems, 0.0, 0.5, 0.0, (level.getRandom().nextDouble() - 0.5) * 0.4, 0.0, (level.getRandom().nextDouble() - 0.5) * 0.4);
        level.removeBlock(blockPos, false);
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.north());
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.east());
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.south());
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.west());
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.above());
    }

    public static @NonNull FallingAnimationTreeBreakingHandler getInstance(@NonNull FallingTreeCommon<?> mod, boolean dropLogsAsItems, boolean dropLeavesAsItems) {
        return INSTANCE.computeIfAbsent(Map.entry(dropLogsAsItems, dropLeavesAsItems), key -> new FallingAnimationTreeBreakingHandler(mod, (Boolean)key.getKey(), (Boolean)key.getValue(), new LeafForceBreaker(mod)));
    }

    @Generated
    public FallingAnimationTreeBreakingHandler(FallingTreeCommon<?> mod, boolean dropLogsAsItems, boolean dropLeavesAsItems, LeafForceBreaker leafForceBreaker) {
        this.mod = mod;
        this.dropLogsAsItems = dropLogsAsItems;
        this.dropLeavesAsItems = dropLeavesAsItems;
        this.leafForceBreaker = leafForceBreaker;
    }
}

