/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.real.cloth;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class ClothHookBase {
    private static final Pattern MINECRAFT_ID_PATTERN = Pattern.compile("#?[a-z0-9_.-]+:[a-z0-9/._-]+");
    private final @NonNull FallingTreeCommon<?> mod;

    protected @NonNull String getFieldName(@Nullable String category, @NonNull String fieldName) {
        return Optional.ofNullable(category).filter(c -> !c.isBlank()).map(c -> "text.autoconfig.fallingtree.option." + c + "." + fieldName).orElseGet(() -> "text.autoconfig.fallingtree.option." + fieldName);
    }

    protected @NonNull Stream<IComponent> getTooltipsInternal(@Nullable String category, @NonNull String fieldName, int count) {
        String tooltipKey = this.getFieldName(category, fieldName) + ".@Tooltip";
        LinkedList<CallSite> keys = new LinkedList<CallSite>();
        if (count <= 1) {
            keys.add((CallSite)((Object)tooltipKey));
        } else {
            for (int i = 0; i < count; ++i) {
                keys.add((CallSite)((Object)(tooltipKey + "[" + i + "]")));
            }
        }
        return keys.stream().map(x$0 -> this.mod.translate((String)x$0, new Object[0]));
    }

    protected @NonNull Function<String, Optional<IComponent>> getMinecraftBlockIdCellError() {
        return value -> Optional.ofNullable(value).map(v -> MINECRAFT_ID_PATTERN.matcher((CharSequence)v).matches()).filter(v -> v == false).map(v -> this.mod.translate("text.autoconfig.fallingtree.error.invalidBlockResourceLocation", new Object[0]));
    }

    protected @NonNull Function<String, Optional<IComponent>> getMinecraftItemIdCellError() {
        return value -> Optional.ofNullable(value).map(v -> MINECRAFT_ID_PATTERN.matcher((CharSequence)v).matches()).filter(v -> v == false).map(v -> this.mod.translate("text.autoconfig.fallingtree.error.invalidItemResourceLocation", new Object[0]));
    }

    @Generated
    public ClothHookBase(@NonNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }

    @Generated
    protected @NonNull FallingTreeCommon<?> getMod() {
        return this.mod;
    }
}

