/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.handler;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.Hud;
import bre2el.fpsreducer.util.ModLib;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.Identifier;
import net.minecraftforge.client.gui.overlay.ForgeLayer;

public class OverlayEventHandler
implements ForgeLayer {
    private Minecraft mc;
    private int fpsCounter = 0;
    private long prevUpdateTime = 0L;
    public static OverlayEventHandler INSTANCE;
    private final Identifier ID = Identifier.fromNamespaceAndPath((String)"fpsreducer", (String)"hud");

    public OverlayEventHandler() {
        this.mc = Minecraft.getInstance();
        INSTANCE = this;
    }

    public Identifier id() {
        return this.ID;
    }

    public void render(GuiGraphics pGuiGraphics, DeltaTracker dt) {
        if (!Config.CURRENT.hudEnabled) {
            return;
        }
        ++this.fpsCounter;
        long curTime = System.currentTimeMillis();
        long elapsedTime = curTime - this.prevUpdateTime;
        if (elapsedTime >= 1000L) {
            int curFPS = Math.round((float)this.fpsCounter * (1000.0f / (float)elapsedTime));
            this.fpsCounter = 0;
            double cpuLoad = Config.GLOBAL.cpuUsageThread == 0 ? ModLib.getThreadCpuUsage(Config.GLOBAL.cpuUsageType == 1) : ModLib.getCpuUsage(Config.GLOBAL.cpuUsageType == 1);
            Hud.getInstance().setFPSCPUData(curFPS, cpuLoad);
            Hud.getInstance().updateHudText();
            this.prevUpdateTime = curTime;
        }
        if (!this.mc.getDebugOverlay().showDebugScreen()) {
            Hud.getInstance().drawHud(pGuiGraphics, this.fpsCounter == 0);
        }
    }

    static {
        new OverlayEventHandler();
    }
}

