/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CheckboxButtonEx
extends AbstractButton {
    private static final WidgetSprites CHECKBOX_TEXTURES = new WidgetSprites(Identifier.parse((String)"fpsreducer:checkbox/box_enabled"), Identifier.parse((String)"fpsreducer:checkbox/box_disabled"), Identifier.parse((String)"fpsreducer:checkbox/box_enabled_highlighted"), Identifier.parse((String)"fpsreducer:checkbox/box_disabled_highlighted"));
    protected final IPressable onPress;
    private boolean checked;

    public CheckboxButtonEx(int x, int y, int w, int h, Component msg, boolean isChecked, IPressable onPress) {
        super(x, y, w, h, msg);
        this.onPress = onPress;
        this.checked = isChecked;
    }

    public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            Minecraft mc = Minecraft.getInstance();
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, CHECKBOX_TEXTURES.get(this.isChecked(), this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
        }
    }

    protected int getYImage(boolean hovered) {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (hovered) {
            i = 2;
        }
        return i;
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.onPress.onPress(this);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setIsChecked(boolean check) {
        this.checked = check;
    }

    public void updateWidgetNarration(NarrationElementOutput narration) {
        narration.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narration.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                narration.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPress(CheckboxButtonEx var1);
    }
}

