/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleItemWhitelist;
import com.supermartijn642.trashcans.packet.PacketToggleLiquidWhitelist;
import com.supermartijn642.trashcans.screen.ArrowButton;
import com.supermartijn642.trashcans.screen.CheckBox;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import com.supermartijn642.trashcans.screen.UltimateTrashCanContainer;
import com.supermartijn642.trashcans.screen.WhitelistButton;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;

public class UltimateTrashCanScreen
extends TrashCanScreen<UltimateTrashCanContainer> {
    public static final Identifier BACKGROUND = Identifier.fromNamespaceAndPath((String)"trashcans", (String)"ultimate_screen");
    private WhitelistButton itemWhitelistButton;
    private WhitelistButton liquidWhitelistButton;
    private CheckBox checkBox;
    private ArrowButton leftArrow;
    private ArrowButton rightArrow;
    private boolean shift;
    private boolean control;

    public UltimateTrashCanScreen() {
        super("trashcans.gui.ultimate_trash_can.title");
    }

    protected void addWidgets(TrashCanBlockEntity entity) {
        this.itemWhitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, this.height() - 185, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketToggleItemWhitelist(((UltimateTrashCanContainer)this.container).getBlockEntityPos()))));
        this.itemWhitelistButton.update(entity.itemFilterWhitelist);
        this.liquidWhitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, this.height() - 155, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketToggleLiquidWhitelist(((UltimateTrashCanContainer)this.container).getBlockEntityPos()))));
        this.liquidWhitelistButton.update(entity.liquidFilterWhitelist);
        this.checkBox = (CheckBox)this.addWidget((Widget)new CheckBox(21, 127, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketToggleEnergyLimit(((UltimateTrashCanContainer)this.container).getBlockEntityPos()))));
        this.checkBox.update(entity.useEnergyLimit);
        this.leftArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(49, 127, true, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeEnergyLimit(((UltimateTrashCanContainer)this.container).getBlockEntityPos(), this.shift ? (this.control ? -100000 : -100) : (this.control ? -10000 : -1000)))));
        this.leftArrow.setActive(entity.useEnergyLimit);
        this.rightArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(170, 127, false, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeEnergyLimit(((UltimateTrashCanContainer)this.container).getBlockEntityPos(), this.shift ? (this.control ? 100000 : 100) : (this.control ? 10000 : 1000)))));
        this.rightArrow.setActive(entity.useEnergyLimit);
    }

    protected void renderTooltips(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderTooltips(context, graphics, mouseX, mouseY, (Object)entity);
        if (this.leftArrow.isFocused() && this.leftArrow.isActive()) {
            graphics.submitTooltip(c -> {
                String[] stringArray = new String[1];
                stringArray[0] = "" + (this.shift ? (this.control ? -100000 : -100) : (this.control ? -10000 : -1000));
                c.literal(stringArray);
            }, (float)mouseX, (float)mouseY);
        }
        if (this.rightArrow.isFocused() && this.rightArrow.isActive()) {
            graphics.submitTooltip(c -> {
                String[] stringArray = new String[1];
                stringArray[0] = "+" + (this.shift ? (this.control ? 100000 : 100) : (this.control ? 10000 : 1000));
                c.literal(stringArray);
            }, (float)mouseX, (float)mouseY);
        }
    }

    protected void update(TrashCanBlockEntity entity) {
        super.update((Object)entity);
        this.itemWhitelistButton.update(entity.itemFilterWhitelist);
        this.liquidWhitelistButton.update(entity.liquidFilterWhitelist);
        this.checkBox.update(entity.useEnergyLimit);
        this.leftArrow.setActive(entity.useEnergyLimit);
        this.rightArrow.setActive(entity.useEnergyLimit);
    }

    @Override
    protected Identifier getBackground() {
        return BACKGROUND;
    }

    @Override
    protected void drawText(GuiGraphicsHelper graphics, TrashCanBlockEntity entity) {
        graphics.submitText((FormattedText)TextComponents.translation((String)"trashcans.gui.ultimate_trash_can.item_filter").get(), 8.0f, 53.0f);
        graphics.submitText((FormattedText)TextComponents.translation((String)"trashcans.gui.ultimate_trash_can.liquid_filter").get(), 8.0f, 83.0f);
        graphics.submitText((FormattedText)TextComponents.translation((String)"trashcans.gui.ultimate_trash_can.energy_limit").get(), 8.0f, 113.0f);
        graphics.submitText((FormattedText)TextComponents.string((String)I18n.get((String)"trashcans.gui.energy_trash_can.value", (Object[])new Object[0]).replace("$number$", "" + entity.energyLimit)).get(), 114.0f, 132.0f, p -> p.centerHorizontally());
    }

    protected boolean keyPressed(KeyEvent event, boolean hasBeenHandled, TrashCanBlockEntity object) {
        this.shift = event.hasShiftDown();
        this.control = event.hasControlDown();
        return super.keyPressed(event, hasBeenHandled, (Object)object);
    }

    protected boolean keyReleased(KeyEvent event, boolean hasBeenHandled, TrashCanBlockEntity object) {
        this.shift = event.hasShiftDown();
        this.control = event.hasControlDown();
        return super.keyReleased(event, hasBeenHandled, (Object)object);
    }
}

