/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.screen.ArrowButton;
import com.supermartijn642.trashcans.screen.CheckBox;
import com.supermartijn642.trashcans.screen.EnergyTrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;

public class EnergyTrashCanScreen
extends TrashCanScreen<EnergyTrashCanContainer> {
    public static final Identifier BACKGROUND = Identifier.fromNamespaceAndPath((String)"trashcans", (String)"energy_screen");
    private CheckBox checkBox;
    private ArrowButton leftArrow;
    private ArrowButton rightArrow;
    private boolean shift;
    private boolean control;

    public EnergyTrashCanScreen() {
        super("trashcans.gui.energy_trash_can.title");
    }

    protected void addWidgets(TrashCanBlockEntity entity) {
        this.checkBox = (CheckBox)this.addWidget((Widget)new CheckBox(21, 66, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketToggleEnergyLimit(((EnergyTrashCanContainer)this.container).getBlockEntityPos()))));
        this.checkBox.update(entity.useEnergyLimit);
        this.leftArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(49, 66, true, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeEnergyLimit(((EnergyTrashCanContainer)this.container).getBlockEntityPos(), this.shift ? (this.control ? -1 : -100) : (this.control ? -10000 : -1000)))));
        this.leftArrow.setActive(entity.useEnergyLimit);
        this.rightArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(170, 66, false, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeEnergyLimit(((EnergyTrashCanContainer)this.container).getBlockEntityPos(), this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)))));
        this.rightArrow.setActive(entity.useEnergyLimit);
    }

    protected void renderTooltips(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderTooltips(context, graphics, mouseX, mouseY, (Object)entity);
        if (this.leftArrow.isFocused() && this.leftArrow.isActive()) {
            graphics.submitTooltip(c -> {
                Component[] componentArray = new Component[4];
                componentArray[0] = TextComponents.string((String)("-" + (this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)))).get();
                componentArray[1] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change1", (Object[])new Object[]{"-100"}).color(ChatFormatting.AQUA).get();
                componentArray[2] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change2", (Object[])new Object[]{"-10000"}).color(ChatFormatting.AQUA).get();
                componentArray[3] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change3", (Object[])new Object[]{"-1"}).color(ChatFormatting.AQUA).get();
                c.text(componentArray);
            }, (float)mouseX, (float)mouseY);
        }
        if (this.rightArrow.isFocused() && this.rightArrow.isActive()) {
            graphics.submitTooltip(c -> {
                Component[] componentArray = new Component[4];
                componentArray[0] = TextComponents.string((String)("+" + (this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)))).get();
                componentArray[1] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change1", (Object[])new Object[]{"+100"}).color(ChatFormatting.AQUA).get();
                componentArray[2] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change2", (Object[])new Object[]{"+10000"}).color(ChatFormatting.AQUA).get();
                componentArray[3] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change3", (Object[])new Object[]{"+1"}).color(ChatFormatting.AQUA).get();
                c.text(componentArray);
            }, (float)mouseX, (float)mouseY);
        }
    }

    protected void update(TrashCanBlockEntity entity) {
        super.update((Object)entity);
        this.checkBox.update(entity.useEnergyLimit);
        this.leftArrow.setActive(entity.useEnergyLimit);
        this.rightArrow.setActive(entity.useEnergyLimit);
    }

    @Override
    protected Identifier getBackground() {
        return BACKGROUND;
    }

    @Override
    protected void drawText(GuiGraphicsHelper graphics, TrashCanBlockEntity entity) {
        graphics.submitText((FormattedText)TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit").get(), 8.0f, 52.0f);
        graphics.submitText((FormattedText)TextComponents.string((String)I18n.get((String)"trashcans.gui.energy_trash_can.value", (Object[])new Object[0]).replace("$number$", "" + entity.energyLimit)).get(), 114.0f, 71.0f, p -> p.centerHorizontally());
    }

    protected boolean keyPressed(KeyEvent event, boolean hasBeenHandled, TrashCanBlockEntity object) {
        this.shift = event.hasShiftDown();
        this.control = event.hasControlDown();
        return super.keyPressed(event, hasBeenHandled, (Object)object);
    }

    protected boolean keyReleased(KeyEvent event, boolean hasBeenHandled, TrashCanBlockEntity object) {
        this.shift = event.hasShiftDown();
        this.control = event.hasControlDown();
        return super.keyReleased(event, hasBeenHandled, (Object)object);
    }
}

