/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.filter;

import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class LiquidTrashCanFilters {
    private static final Map<String, IFilterManager> managers = new HashMap<String, IFilterManager>();

    public static void register(IFilterManager manager, String id) {
        managers.put(id, manager);
    }

    public static ItemFilter createFilter(ItemStack stack) {
        for (Map.Entry<String, IFilterManager> entry : managers.entrySet()) {
            ItemFilter filter = entry.getValue().createFilter(stack);
            if (filter == null || !filter.isValid()) continue;
            filter.setId(entry.getKey());
            return filter;
        }
        return null;
    }

    public static void write(ItemFilter filter, ValueOutput output) {
        output.putString("id", filter.getId());
        filter.write(output.child("filter"));
    }

    public static ItemFilter read(ValueInput input) {
        String id = input.getStringOr("id", "");
        if (managers.containsKey(id)) {
            ItemFilter filter = managers.get(id).readFilter(input.childOrEmpty("filter"));
            filter.setId(id);
            return filter.isValid() ? filter : null;
        }
        return null;
    }
}

