/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.core.util.TriFunction;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.screen.DummySlot;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TrashCanBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    public static final int DEFAULT_ENERGY_LIMIT = 10000;
    public static final int MAX_ENERGY_LIMIT = 10000000;
    public static final int MIN_ENERGY_LIMIT = 1;
    public final IItemHandler ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            for (ItemStack filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist ? ItemStack.EMPTY : stack;
            }
            return TrashCanBlockEntity.this.itemFilterWhitelist ? stack : ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            for (ItemStack filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.itemFilterWhitelist;
        }
    };
    public final IFluidHandler FLUID_HANDLER = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.liquidFilterWhitelist;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(resource)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist ? resource.getAmount() : 0;
            }
            return TrashCanBlockEntity.this.liquidFilterWhitelist ? 0 : resource.getAmount();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };
    public final TriFunction<Integer, Integer, Integer, Slot> LIQUID_ITEM_HANDLER = (slot, x, y) -> new DummySlot((int)slot, (int)x, (int)y){

        public boolean mayPlace(ItemStack stack) {
            return this.isItemValid(stack);
        }

        @Override
        public ItemStack getItem() {
            return TrashCanBlockEntity.this.liquidItem;
        }

        @Override
        public void set(ItemStack stack) {
            TrashCanBlockEntity.this.liquidItem = stack.copy();
            TrashCanBlockEntity.this.liquidItem.setCount(1);
            TrashCanBlockEntity.this.dataChanged();
        }

        @Override
        public void setChanged() {
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public ItemStack remove(int count) {
            ItemStack result = TrashCanBlockEntity.this.liquidItem.split(count);
            TrashCanBlockEntity.this.dataChanged();
            return result;
        }

        public boolean isItemValid(ItemStack stack) {
            boolean filtered = !TrashCanBlockEntity.this.liquidFilterWhitelist;
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                filtered = TrashCanBlockEntity.this.liquidFilterWhitelist;
                break;
            }
            if (!filtered) {
                return false;
            }
            IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
            if (handler != null) {
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    if (handler.getFluidInTank(tank).isEmpty()) continue;
                    return true;
                }
            }
            return false;
        }
    };
    public final IEnergyStorage ENERGY_STORAGE = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TrashCanBlockEntity.this.useEnergyLimit ? Math.min(maxReceive, TrashCanBlockEntity.this.energyLimit) : maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };
    public final TriFunction<Integer, Integer, Integer, Slot> ENERGY_ITEM_HANDLER = (slot, x, y) -> new DummySlot((int)slot, (int)x, (int)y){

        public boolean mayPlace(ItemStack stack) {
            return this.isItemValid(stack);
        }

        @Override
        public ItemStack getItem() {
            return TrashCanBlockEntity.this.energyItem;
        }

        @Override
        public void set(ItemStack stack) {
            TrashCanBlockEntity.this.energyItem = stack.copy();
            TrashCanBlockEntity.this.energyItem.setCount(1);
            TrashCanBlockEntity.this.dataChanged();
        }

        @Override
        public void setChanged() {
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public ItemStack remove(int count) {
            ItemStack result = TrashCanBlockEntity.this.energyItem.split(count);
            TrashCanBlockEntity.this.dataChanged();
            return result;
        }

        public boolean isItemValid(ItemStack stack) {
            return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
        }
    };
    public final boolean items;
    public final ArrayList<ItemStack> itemFilter = new ArrayList();
    public boolean itemFilterWhitelist = false;
    public final boolean liquids;
    public final ArrayList<ItemFilter> liquidFilter = new ArrayList();
    public boolean liquidFilterWhitelist = false;
    public ItemStack liquidItem = ItemStack.EMPTY;
    public final boolean energy;
    public int energyLimit = 10000;
    public boolean useEnergyLimit = false;
    public ItemStack energyItem = ItemStack.EMPTY;

    public TrashCanBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, boolean items, boolean liquids, boolean energy) {
        super(blockEntityType, pos, state);
        this.items = items;
        this.liquids = liquids;
        this.energy = energy;
        for (int i = 0; i < 9; ++i) {
            this.itemFilter.add(ItemStack.EMPTY);
            this.liquidFilter.add(null);
        }
    }

    public void update() {
        if (this.liquids && !this.liquidItem.isEmpty() && this.liquidItem.getItem() != Items.BUCKET) {
            this.liquidItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> {
                boolean changed = false;
                for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                    if (fluidHandler.getFluidInTank(tank).isEmpty()) continue;
                    fluidHandler.drain(fluidHandler.getFluidInTank(tank), IFluidHandler.FluidAction.EXECUTE);
                    changed = true;
                }
                if (changed) {
                    this.liquidItem = fluidHandler.getContainer();
                    this.dataChanged();
                }
            });
        }
        if (this.energy && !this.energyItem.isEmpty()) {
            this.energyItem.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
                energyStorage.extractEnergy(energyStorage.getEnergyStored(), false);
                this.dataChanged();
            });
        }
    }

    public boolean isRegularItemValid(ItemStack stack) {
        for (ItemStack filter : this.itemFilter) {
            if (filter.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)filter)) continue;
            return this.itemFilterWhitelist;
        }
        return !this.itemFilterWhitelist;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.items && cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.ITEM_HANDLER).cast();
        }
        if (this.liquids && cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.FLUID_HANDLER).cast();
        }
        if (this.energy && cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.ENERGY_STORAGE).cast();
        }
        return LazyOptional.empty();
    }

    protected void writeData(ValueOutput output) {
        int i;
        if (this.level.isClientSide()) {
            return;
        }
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                if (this.itemFilter.get(i).isEmpty()) continue;
                output.store("itemFilter" + i, ItemStack.CODEC, (Object)this.itemFilter.get(i));
            }
            output.putBoolean("itemFilterWhitelist", this.itemFilterWhitelist);
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                if (this.liquidFilter.get(i) == null) continue;
                LiquidTrashCanFilters.write(this.liquidFilter.get(i), output.child("liquidFilter" + i));
            }
            output.putBoolean("liquidFilterWhitelist", this.liquidFilterWhitelist);
            if (!this.liquidItem.isEmpty()) {
                output.store("liquidItem", ItemStack.CODEC, (Object)this.liquidItem);
            }
        }
        if (this.energy) {
            output.putBoolean("useEnergyLimit", this.useEnergyLimit);
            output.putInt("energyLimit", this.energyLimit);
            if (!this.energyItem.isEmpty()) {
                output.store("energyItem", ItemStack.CODEC, (Object)this.energyItem);
            }
        }
    }

    protected void readData(ValueInput input) {
        int i;
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                this.itemFilter.set(i, input.read("itemFilter" + i, ItemStack.CODEC).orElse(ItemStack.EMPTY));
            }
            this.itemFilterWhitelist = input.getBooleanOr("itemFilterWhitelist", false);
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                this.liquidFilter.set(i, input.child("liquidFilter" + i).map(LiquidTrashCanFilters::read).orElse(null));
            }
            this.liquidFilterWhitelist = input.getBooleanOr("liquidFilterWhitelist", false);
            this.liquidItem = input.read("liquidItem", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        }
        if (this.energy) {
            this.useEnergyLimit = input.getBooleanOr("useEnergyLimit", false);
            this.energyLimit = input.getIntOr("energyLimit", 10000);
            this.energyItem = input.read("energyItem", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        }
    }
}

