/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server.blocks;

import atomicstryker.dynamiclights.server.DynamicLights;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;

public class BlockLitWater
extends LiquidBlock {
    public BlockLitWater(FlowingFluid flowingFluid, BlockBehaviour.Properties properties) {
        super(flowingFluid, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.POWER, (Comparable)Integer.valueOf(15)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWER});
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return true;
    }

    public void randomTick(BlockState blockState, ServerLevel serverWorld, BlockPos blockPos, RandomSource random) {
        if (!DynamicLights.isKnownLitPosition((Level)serverWorld, blockPos)) {
            serverWorld.setBlock(blockPos, Blocks.WATER.defaultBlockState(), 3);
        }
    }

    public void tick(BlockState blockState, ServerLevel serverWorld, BlockPos blockPos, RandomSource rand) {
        if (!DynamicLights.isKnownLitPosition((Level)serverWorld, blockPos)) {
            serverWorld.setBlock(blockPos, Blocks.WATER.defaultBlockState(), 3);
        } else {
            serverWorld.scheduleTick(blockPos, (Block)this, 150);
        }
    }
}

