/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.gametest;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.block.UncolossalChest;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.cyclopscore.gametest.GameTest;

public class GameTestsCommon {
    public static final String TEMPLATE_EMPTY = "colossalchests:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(1, 0, 1);

    @GameTest(template="colossalchests:empty10")
    public void testUncolossalPlacementDirection(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.SOUTH);
        helper.succeedWhen(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.value(), POS.south());
            helper.assertBlockProperty(POS.south(), UncolossalChest.FACING, (Comparable)Direction.NORTH);
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testUncolossalPlacementDirectionOpposite(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.NORTH);
        helper.succeedWhen(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.value(), POS.north());
            helper.assertBlockProperty(POS.north(), UncolossalChest.FACING, (Comparable)Direction.NORTH);
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testUncolossalHoppers(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.value());
        helper.setBlock(POS.below(), Blocks.HOPPER);
        helper.spawnItem(Items.APPLE, POS.above().above());
        helper.succeedWhen(() -> this.assertHopperContains(helper, POS.below(), new ItemStack((ItemLike)Items.APPLE)));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood2x2(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 2);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 2));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 3);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood5x5(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 5);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 5));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood9x9(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 9);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 9));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3MissingCore(GameTestHelper helper) {
        HashSet excluded = Sets.newHashSet((Object[])new BlockPos[]{POS});
        this.createChest(helper, POS, ChestMaterial.WOOD, 3, excluded);
        helper.succeedWhen(() -> this.assertChestInvalid(helper, POS, ChestMaterial.WOOD, 3, excluded, Sets.newHashSet()));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3MissingWall(GameTestHelper helper) {
        HashSet excluded = Sets.newHashSet((Object[])new BlockPos[]{POS.above()});
        this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet((Iterable)excluded));
        helper.succeedWhen(() -> this.assertChestInvalid(helper, POS, ChestMaterial.WOOD, 3, excluded, Sets.newHashSet()));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3MissingWallMultiple(GameTestHelper helper) {
        HashSet excluded = Sets.newHashSet((Object[])new BlockPos[]{POS.above(), POS.above().above(), POS.above().north()});
        this.createChest(helper, POS, ChestMaterial.WOOD, 3, excluded);
        helper.succeedWhen(() -> this.assertChestInvalid(helper, POS, ChestMaterial.WOOD, 3, excluded, Sets.newHashSet()));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalCopper5x5(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.COPPER, 5);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.COPPER, 5));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalCopper9x9(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.COPPER, 9);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.COPPER, 9));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalIron5x5(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.IRON, 5);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.IRON, 5));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalIron9x9(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.IRON, 9);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.IRON, 9));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalSilver5x5(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.SILVER, 5);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.SILVER, 5));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalSilver9x9(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.SILVER, 9);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.SILVER, 9));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalGold5x5(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.GOLD, 5);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.GOLD, 5));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalGold9x9(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.GOLD, 9);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.GOLD, 9));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalDiamond5x5(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.DIAMOND, 5);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 5));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalDiamond9x9(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.DIAMOND, 9);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 9));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalObsidian5x5(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.OBSIDIAN, 5);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.OBSIDIAN, 5));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalObsidian9x9(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.OBSIDIAN, 9);
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.OBSIDIAN, 9));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood5x5HopperInsert(GameTestHelper helper) {
        this.createChest(helper, POS.above().south(), ChestMaterial.WOOD, 5);
        helper.setBlock(POS.above(), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.SOUTH));
        helper.spawnItem(Items.APPLE, POS.above().above());
        helper.spawnItem(Items.WHITE_WOOL, POS.above().above());
        helper.spawnItem(Items.ACACIA_LEAVES, POS.above().above());
        helper.succeedWhen(() -> {
            this.assertCoreContains(helper, POS.above().south(), new ItemStack((ItemLike)Items.APPLE));
            this.assertCoreContains(helper, POS.above().south(), new ItemStack((ItemLike)Items.WHITE_WOOL));
            this.assertCoreContains(helper, POS.above().south(), new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood5x5HopperExtract(GameTestHelper helper) {
        BlockEntityColossalChest core = this.createChest(helper, POS.above().south(), ChestMaterial.WOOD, 5);
        helper.setBlock(POS.south(), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.SOUTH));
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        core.getInventory().setItem(1, new ItemStack((ItemLike)Items.WHITE_WOOL));
        core.getInventory().setItem(2, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        helper.succeedWhen(() -> {
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.APPLE));
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.WHITE_WOOL));
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood5x5HopperInsertExtract(GameTestHelper helper) {
        if (this.isFabric()) {
            helper.succeed();
            return;
        }
        BlockEntityColossalChest core = this.createChest(helper, POS.above().south(), ChestMaterial.WOOD, 5);
        helper.setBlock(POS.above(), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.SOUTH));
        helper.setBlock(POS.south(), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.SOUTH));
        helper.spawnItem(Items.APPLE, POS.above().above());
        helper.spawnItem(Items.WHITE_WOOL, POS.above().above());
        helper.spawnItem(Items.ACACIA_LEAVES, POS.above().above());
        helper.succeedWhen(() -> {
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.APPLE));
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.WHITE_WOOL));
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood5x5Interfaces(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.WOOD, 5, Sets.newHashSet(), Sets.newHashSet((Object[])new BlockPos[]{POS.north().above(), POS.south().above()}));
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.WOOD, 5, Sets.newHashSet((Object[])new BlockPos[]{POS.north().above(), POS.south().above()}), true));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalDiamond5x5Interfaces(GameTestHelper helper) {
        this.createChest(helper, POS, ChestMaterial.DIAMOND, 5, Sets.newHashSet(), Sets.newHashSet((Object[])new BlockPos[]{POS.north().above(), POS.south().above()}));
        helper.succeedWhen(() -> this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 5, Sets.newHashSet((Object[])new BlockPos[]{POS.north().above(), POS.south().above()}), true));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3InterfacesMissingWall(GameTestHelper helper) {
        HashSet excluded = Sets.newHashSet((Object[])new BlockPos[]{POS.above()});
        this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet((Iterable)excluded), Sets.newHashSet((Object[])new BlockPos[]{POS.north()}));
        helper.succeedWhen(() -> this.assertChestInvalid(helper, POS, ChestMaterial.WOOD, 3, excluded, Sets.newHashSet((Object[])new BlockPos[]{POS.north()})));
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood5x5InterfacesHopperInsertExtract(GameTestHelper helper) {
        if (this.isFabric()) {
            helper.succeed();
            return;
        }
        this.createChest(helper, POS.above(), ChestMaterial.WOOD, 5, Sets.newHashSet(), Sets.newHashSet((Object[])new BlockPos[]{POS.offset(0, 5, 0), POS.above().south()}));
        helper.setBlock(POS.offset(0, 5, 0).above(), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.setBlock(POS.south(), (BlockState)Blocks.HOPPER.defaultBlockState().setValue((Property)HopperBlock.FACING, (Comparable)Direction.DOWN));
        helper.spawnItem(Items.APPLE, POS.offset(0, 5, 0).above().above());
        helper.spawnItem(Items.WHITE_WOOL, POS.offset(0, 5, 0).above().above());
        helper.spawnItem(Items.ACACIA_LEAVES, POS.offset(0, 5, 0).above().above());
        helper.succeedWhen(() -> {
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.APPLE));
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.WHITE_WOOL));
            this.assertHopperContains(helper, POS.south(), new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3Upgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.COPPER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3UpgradeInsufficientItems(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 22));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.FAIL, (Component)Component.literal((String)"Interaction must fail"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockWall(), 22));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 22));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalCopper3x3Upgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.COPPER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.IRON.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.IRON.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.IRON.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.IRON, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalIron3x3Upgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.IRON, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.SILVER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalSilver3x3Upgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.SILVER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.GOLD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalGold3x3Upgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.GOLD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalDiamond3x3Upgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.DIAMOND, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.OBSIDIAN, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalCopper3x3Downgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.COPPER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalCopper3x3DowngradeInsufficientItems(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.COPPER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockWall(), 22));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.FAIL, (Component)Component.literal((String)"Interaction must fail"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.COPPER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 22));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.WOOD.getBlockWall(), 22));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalIron3x3Downgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.IRON, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.COPPER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.COPPER.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalSilver3x3Downgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.SILVER, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.IRON.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.IRON.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.IRON.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.IRON, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.IRON.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalGold3x3Downgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.GOLD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.SILVER, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.SILVER.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalDiamond3x3Downgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.DIAMOND, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.GOLD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.GOLD.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalObsidian3x3Downgrade(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.OBSIDIAN, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_UPGRADE_TOOL_REVERSE);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockCore(), 1));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockInterface(), 2));
        player.getInventory().add(new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockWall(), 23));
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(POS.getCenter(), Direction.NORTH, helper.absolutePos(POS), false)));
        helper.assertTrue(interactionResult == InteractionResult.SUCCESS, (Component)Component.literal((String)"Interaction must succeed"));
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.DIAMOND, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockCore(), 1));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockInterface(), 2));
            this.assertPlayerInventoryNotContains(helper, player, new ItemStack((ItemLike)ChestMaterial.DIAMOND.getBlockWall(), 23));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockCore(), 1));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockInterface(), 2));
            this.assertPlayerInventoryContains(helper, player, new ItemStack((ItemLike)ChestMaterial.OBSIDIAN.getBlockWall(), 23));
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceWall(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        this.destroyBlock(helper, POS.east());
        helper.setBlock(POS.east(), (Block)ChestMaterial.WOOD.getBlockWall());
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceWallAsPlayer(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        this.destroyBlock(helper, POS.east());
        this.setBlockAsPlayer(helper, POS.east(), ChestMaterial.WOOD.getBlockWall());
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceInterface(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        this.destroyBlock(helper, POS.east().above());
        helper.setBlock(POS.east().above(), (Block)ChestMaterial.WOOD.getBlockInterface());
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceInterfaceAsPlayer(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS, ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        this.destroyBlock(helper, POS.east().above());
        this.setBlockAsPlayer(helper, POS.east().above(), (Block)ChestMaterial.WOOD.getBlockInterface());
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS, ChestMaterial.WOOD, 3, interfaces, false);
            this.assertCoreContains(helper, POS, new ItemStack((ItemLike)Items.APPLE));
            helper.assertEntityNotPresent(EntityType.ITEM);
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceCore(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.offset(4, 1, 4).east().above(), POS.offset(4, 1, 4).south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS.offset(4, 1, 4), ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        core.getInventory().setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        core.getInventory().setItem(2, new ItemStack((ItemLike)Items.WHITE_WOOL));
        this.destroyBlock(helper, POS.offset(4, 1, 4));
        helper.setBlock(POS.offset(4, 1, 4), (Block)ChestMaterial.WOOD.getBlockCore());
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS.offset(4, 1, 4), ChestMaterial.WOOD, 3, interfaces, true);
            helper.assertItemEntityPresent(Items.APPLE);
            helper.assertItemEntityPresent(Items.ACACIA_LEAVES);
            helper.assertItemEntityPresent(Items.WHITE_WOOL);
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3BreakPlaceCoreAsPlayer(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.offset(4, 1, 4).east().above(), POS.offset(4, 1, 4).south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS.offset(4, 1, 4), ChestMaterial.WOOD, 3, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        core.getInventory().setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        core.getInventory().setItem(2, new ItemStack((ItemLike)Items.WHITE_WOOL));
        this.destroyBlock(helper, POS.offset(4, 1, 4));
        this.setBlockAsPlayer(helper, POS.offset(4, 1, 4), (Block)ChestMaterial.WOOD.getBlockCore());
        helper.succeedWhen(() -> {
            this.assertChestValid(helper, POS.offset(4, 1, 4), ChestMaterial.WOOD, 3, interfaces, true);
            helper.assertItemEntityPresent(Items.APPLE);
            helper.assertItemEntityPresent(Items.ACACIA_LEAVES);
            helper.assertItemEntityPresent(Items.WHITE_WOOL);
        });
    }

    @GameTest(template="colossalchests:empty10")
    public void testColossalWood3x3DestroyTnt(GameTestHelper helper) {
        HashSet interfaces = Sets.newHashSet((Object[])new BlockPos[]{POS.east().above(), POS.south().above()});
        BlockEntityColossalChest core = this.createChest(helper, POS.above(), ChestMaterial.WOOD, 2, Sets.newHashSet(), interfaces);
        core.getInventory().setItem(0, new ItemStack((ItemLike)Items.APPLE));
        core.getInventory().setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        helper.setBlock(POS.above().offset(2, 0, 0), Blocks.TNT);
        helper.setBlock(POS.above().offset(2, 1, 0), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertItemEntityPresent(Items.APPLE);
            helper.assertItemEntityPresent(Items.ACACIA_LEAVES);
            helper.assertItemEntityPresent(ChestMaterial.WOOD.getBlockCore().asItem());
            helper.assertItemEntityPresent(ChestMaterial.WOOD.getBlockInterface().asItem());
            helper.assertItemEntityPresent(ChestMaterial.WOOD.getBlockWall().asItem());
        });
    }

    protected BlockEntityColossalChest createChest(GameTestHelper helper, BlockPos pos, ChestMaterial material, int dimension) {
        return this.createChest(helper, pos, material, dimension, Sets.newHashSet());
    }

    protected BlockEntityColossalChest createChest(GameTestHelper helper, BlockPos pos, ChestMaterial material, int dimension, Set<BlockPos> exclude) {
        return this.createChest(helper, pos, material, dimension, exclude, Sets.newHashSet());
    }

    protected BlockEntityColossalChest createChest(GameTestHelper helper, BlockPos pos, ChestMaterial material, int dimension, Set<BlockPos> exclude, Set<BlockPos> interfaces) {
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    BlockPos poso = pos.offset(x, y, z);
                    if (exclude.contains(poso)) continue;
                    if (x == 0 && y == 0 && z == 0) {
                        helper.setBlock(poso, (Block)material.getBlockCore());
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    if (interfaces.contains(poso)) {
                        helper.setBlock(poso, (Block)material.getBlockInterface());
                        continue;
                    }
                    helper.setBlock(poso, (Block)material.getBlockWall());
                }
            }
        }
        return exclude.contains(pos) ? null : (BlockEntityColossalChest)helper.getBlockEntity(pos, BlockEntityColossalChest.class);
    }

    protected int chestSize(int dimension, ChestMaterial material) {
        return (int)Math.ceil(Math.pow(dimension, 3.0) * 27.0 * material.getInventoryMultiplier() / 9.0) * 9;
    }

    protected void assertChestValid(GameTestHelper helper, BlockPos pos, ChestMaterial material, int dimension) {
        this.assertChestValid(helper, pos, material, dimension, Sets.newHashSet(), true);
    }

    protected void assertChestValid(GameTestHelper helper, BlockPos pos, ChestMaterial material, int dimension, Set<BlockPos> interfaces, boolean mustBeEmpty) {
        int inventorySize = this.chestSize(dimension, material);
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    BlockPos poso = pos.offset(x, y, z);
                    if (x == 0 && y == 0 && z == 0) {
                        helper.assertBlockPresent((Block)material.getBlockCore(), poso);
                        helper.assertBlockProperty(poso, (Property)ColossalChest.ENABLED, (Comparable)Boolean.valueOf(true));
                        helper.assertBlockEntityData(poso, BlockEntityColossalChest.class, be -> be.getInventory().getContainerSize() == inventorySize, () -> Component.literal((String)("Inventory is not of size " + inventorySize)));
                        if (!mustBeEmpty) continue;
                        helper.assertBlockEntityData(poso, BlockEntityColossalChest.class, be -> be.getInventory().isEmpty(), () -> Component.literal((String)"Inventory is not empty"));
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    if (interfaces.contains(poso)) {
                        helper.assertBlockPresent((Block)material.getBlockInterface(), poso);
                        helper.assertBlockProperty(poso, (Property)Interface.ENABLED, (Comparable)Boolean.valueOf(true));
                        continue;
                    }
                    helper.assertBlockPresent((Block)material.getBlockWall(), poso);
                    helper.assertBlockProperty(poso, (Property)ChestWall.ENABLED, (Comparable)Boolean.valueOf(true));
                }
            }
        }
    }

    protected void assertChestInvalid(GameTestHelper helper, BlockPos pos, ChestMaterial material, int dimension, Set<BlockPos> exclude, Set<BlockPos> interfaces) {
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                for (int z = 0; z < dimension; ++z) {
                    BlockPos poso = pos.offset(x, y, z);
                    if (exclude.contains(poso)) {
                        helper.assertBlockPresent(Blocks.AIR, poso);
                        continue;
                    }
                    if (x == 0 && y == 0 && z == 0) {
                        helper.assertBlockPresent((Block)material.getBlockCore(), poso);
                        helper.assertBlockProperty(poso, (Property)ColossalChest.ENABLED, (Comparable)Boolean.valueOf(false));
                        helper.assertBlockEntityData(poso, BlockEntityColossalChest.class, be -> be.getInventory().getContainerSize() == 0, () -> Component.literal((String)"Inventory is not of size zero"));
                        helper.assertBlockEntityData(poso, BlockEntityColossalChest.class, be -> be.getInventory().isEmpty(), () -> Component.literal((String)"Inventory is not empty"));
                        continue;
                    }
                    if (x != 0 && y != 0 && z != 0 && x != dimension - 1 && y != dimension - 1 && z != dimension - 1) continue;
                    if (interfaces.contains(poso)) {
                        helper.assertBlockPresent((Block)material.getBlockInterface(), poso);
                        helper.assertBlockProperty(poso, (Property)Interface.ENABLED, (Comparable)Boolean.valueOf(false));
                        continue;
                    }
                    helper.assertBlockPresent((Block)material.getBlockWall(), poso);
                    helper.assertBlockProperty(poso, (Property)ChestWall.ENABLED, (Comparable)Boolean.valueOf(false));
                }
            }
        }
    }

    protected void assertHopperContains(GameTestHelper helper, BlockPos pos, ItemStack itemStack) {
        helper.assertBlockEntityData(pos, HopperBlockEntity.class, be -> {
            for (int i = 0; i < be.getContainerSize(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)be.getItem(i), (ItemStack)itemStack)) continue;
                return true;
            }
            return false;
        }, () -> Component.literal((String)"Hopper does not contain item"));
    }

    protected void assertCoreContains(GameTestHelper helper, BlockPos pos, ItemStack itemStack) {
        helper.assertBlockEntityData(pos, BlockEntityColossalChest.class, be -> {
            for (int i = 0; i < be.getInventory().getContainerSize(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)be.getInventory().getItem(i), (ItemStack)itemStack)) continue;
                return true;
            }
            return false;
        }, () -> Component.literal((String)"Colossal chest core does not contain item"));
    }

    protected void assertPlayerInventoryContains(GameTestHelper helper, Player player, ItemStack itemStack) {
        boolean contains = false;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)player.getInventory().getItem(i), (ItemStack)itemStack)) continue;
            contains = true;
            break;
        }
        helper.assertTrue(contains, (Component)Component.literal((String)"Player does not contain item"));
    }

    protected void assertPlayerInventoryNotContains(GameTestHelper helper, Player player, ItemStack itemStack) {
        boolean contains = false;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)player.getInventory().getItem(i), (ItemStack)itemStack)) continue;
            contains = true;
            break;
        }
        helper.assertFalse(contains, (Component)Component.literal((String)"Player does contain item"));
    }

    protected void destroyBlock(GameTestHelper helper, BlockPos pos) {
        BlockState blockState = helper.getBlockState(pos);
        boolean removed = helper.getLevel().removeBlock(helper.absolutePos(pos), false);
        if (removed) {
            blockState.getBlock().destroy((LevelAccessor)helper.getLevel(), helper.absolutePos(pos), blockState);
        }
    }

    private void setBlockAsPlayer(GameTestHelper helper, BlockPos pos, Block block) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)block);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        InteractionResult interactionResult = itemStack.useOn(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(pos.getCenter(), Direction.DOWN, helper.absolutePos(pos), false)));
        helper.assertTrue(interactionResult.consumesAction(), (Component)Component.literal((String)"Block placement as player failed"));
    }

    protected boolean isFabric() {
        try {
            Class.forName("net.fabricmc.fabric.api.transfer.v1.item.ItemStorage");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

