/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.render.blockentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.Identifier;
import net.minecraft.world.phys.Vec3;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.client.render.blockentity.RenderTileEntityChestBase;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class RenderTileEntityColossalChest
extends RenderTileEntityChestBase<BlockEntityColossalChest, RenderState> {
    public static final Map<ChestMaterial, Identifier> TEXTURES_CHEST = Maps.newHashMap();
    public static final Map<ChestMaterial, Identifier> TEXTURES_INTERFACE = Maps.newHashMap();

    public RenderTileEntityColossalChest(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void handleRotation(RenderState renderState, PoseStack poseStack) {
        if (renderState.structureComplete) {
            Vec3 renderOffset = renderState.renderOffset;
            poseStack.translate(-renderOffset.x, -renderOffset.y, -renderOffset.z);
        }
        super.handleRotation(renderState, poseStack);
        poseStack.translate(0.0f, (float)renderState.sizeSingular * 0.0625f, 0.0f);
        float size = (float)renderState.sizeSingular * 1.125f;
        poseStack.scale(size, size, size);
    }

    @Override
    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.structureComplete) {
            poseStack.pushPose();
            super.submit(renderState, poseStack, submitNodeCollector, cameraRenderState);
            if (renderState.openNessRaw == 0.0f && (GeneralConfig.alwaysShowInterfaceOverlay || Minecraft.getInstance().player.isCrouching())) {
                poseStack.pushPose();
                Material materialInterface = this.getMaterialInterface(renderState);
                submitNodeCollector.submitCustomGeometry(poseStack, RenderTypes.text((Identifier)materialInterface.atlasLocation()), (pose, vertexConsumer) -> {
                    for (Vec3i interfaceLocation : renderState.interfaceLocations) {
                        float translateX = (float)((double)interfaceLocation.getX() - cameraRenderState.pos.x());
                        float translateY = (float)((double)interfaceLocation.getY() - cameraRenderState.pos.y());
                        float translateZ = (float)((double)interfaceLocation.getZ() - cameraRenderState.pos.z());
                        poseStack.translate(translateX, translateY, translateZ);
                        this.submitInterface(poseStack, vertexConsumer, this.materials.get(materialInterface), interfaceLocation.equals((Object)renderState.blockPos), renderState.lightCoords);
                        poseStack.translate(-translateX, -translateY, -translateZ);
                    }
                });
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    @Override
    public void extractRenderState(BlockEntityColossalChest blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPosition, breakProgress);
        renderState.material = blockEntity.getMaterial();
        renderState.direction = blockEntity.getRotation().getOpposite();
        renderState.structureComplete = blockEntity.isStructureComplete();
        renderState.renderOffset = blockEntity.getRenderOffset();
        renderState.sizeSingular = blockEntity.getSizeSingular();
        renderState.interfaceLocations = blockEntity.getInterfaceLocations();
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    @Override
    protected Direction getDirection(RenderState renderState) {
        return renderState.direction;
    }

    @Override
    protected Material getMaterial(RenderState renderState) {
        return new Material(Sheets.CHEST_SHEET, TEXTURES_CHEST.get(renderState.material));
    }

    protected Material getMaterialInterface(RenderState renderState) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, TEXTURES_INTERFACE.get(renderState.material));
    }

    protected void setMatrixOrientation(PoseStack matrixStack, Direction direction) {
        float translateX = -1.0f - (float)direction.getStepX();
        float translateY = direction.getStepY();
        float translateZ = direction.getStepZ();
        if (direction == Direction.NORTH) {
            translateZ += 1.0f;
            translateX += 2.0f;
            translateY -= 1.0f;
        } else if (direction == Direction.EAST) {
            translateX += 3.0f;
            translateY -= 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.WEST) {
            translateY -= 1.0f;
        } else if (direction == Direction.SOUTH) {
            translateX += 1.0f;
            translateY -= 1.0f;
        } else if (direction == Direction.UP) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == Direction.DOWN) {
            translateX += 1.0f;
        }
        matrixStack.translate(translateX * 16.0f, translateY * 16.0f, translateZ * 16.0f);
        int rotationY = 0;
        int rotationX = 0;
        if (direction == Direction.SOUTH) {
            rotationY = 0;
        } else if (direction == Direction.NORTH) {
            rotationY = 180;
        } else if (direction == Direction.EAST) {
            rotationY = 90;
        } else if (direction == Direction.WEST) {
            rotationY = -90;
        } else if (direction == Direction.UP) {
            rotationX = -90;
        } else if (direction == Direction.DOWN) {
            rotationX = 90;
        }
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)rotationY));
        matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)rotationX));
    }

    protected void submitInterface(PoseStack matrixStack, VertexConsumer buffer, TextureAtlasSprite sprite, boolean core, int combinedLightIn) {
        for (Direction side : Direction.values()) {
            matrixStack.pushPose();
            float scale = 0.063f;
            matrixStack.scale(scale, scale, scale);
            matrixStack.scale(1.0f, -1.0f, 1.0f);
            this.setMatrixOrientation(matrixStack, side);
            float indent = -0.2f;
            if (side == Direction.UP) {
                indent = -15.8f;
            }
            if (side == Direction.DOWN) {
                indent *= 2.0f;
            }
            int alpha = 255;
            float posMin = core ? 5.0f : 6.0f;
            float posMax = 16.0f - posMin;
            float uvScale = posMin / 16.0f;
            float uMin = (sprite.getU1() - sprite.getU0()) * uvScale + sprite.getU0();
            float uMax = (sprite.getU1() - sprite.getU0()) * (1.0f - uvScale) + sprite.getU0();
            float vMin = (sprite.getV1() - sprite.getV0()) * uvScale + sprite.getV0();
            float vMax = (sprite.getV1() - sprite.getV0()) * (1.0f - uvScale) + sprite.getV0();
            Matrix4f matrix = matrixStack.last().pose();
            buffer.addVertex((Matrix4fc)matrix, posMax, posMax, indent).setColor(255, 255, 255, alpha).setUv(uMin, vMax).setLight(combinedLightIn);
            buffer.addVertex((Matrix4fc)matrix, posMax, posMin, indent).setColor(255, 255, 255, alpha).setUv(uMin, vMin).setLight(combinedLightIn);
            buffer.addVertex((Matrix4fc)matrix, posMin, posMin, indent).setColor(255, 255, 255, alpha).setUv(uMax, vMin).setLight(combinedLightIn);
            buffer.addVertex((Matrix4fc)matrix, posMin, posMax, indent).setColor(255, 255, 255, alpha).setUv(uMax, vMax).setLight(combinedLightIn);
            matrixStack.popPose();
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        boolean christmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        TEXTURES_CHEST.put(ChestMaterial.WOOD, Identifier.parse((String)("entity/chest/" + (christmas ? "christmas" : "normal"))));
        TEXTURES_CHEST.put(ChestMaterial.COPPER, Identifier.parse((String)"entity/chest/copper"));
        TEXTURES_CHEST.put(ChestMaterial.IRON, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_iron"));
        TEXTURES_CHEST.put(ChestMaterial.SILVER, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_silver"));
        TEXTURES_CHEST.put(ChestMaterial.GOLD, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_gold"));
        TEXTURES_CHEST.put(ChestMaterial.DIAMOND, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_diamond"));
        TEXTURES_CHEST.put(ChestMaterial.OBSIDIAN, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"models/chest_obsidian"));
        TEXTURES_INTERFACE.put(ChestMaterial.WOOD, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_wood"));
        TEXTURES_INTERFACE.put(ChestMaterial.COPPER, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_copper"));
        TEXTURES_INTERFACE.put(ChestMaterial.IRON, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_iron"));
        TEXTURES_INTERFACE.put(ChestMaterial.SILVER, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_silver"));
        TEXTURES_INTERFACE.put(ChestMaterial.GOLD, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_gold"));
        TEXTURES_INTERFACE.put(ChestMaterial.DIAMOND, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_diamond"));
        TEXTURES_INTERFACE.put(ChestMaterial.OBSIDIAN, Identifier.fromNamespaceAndPath((String)"colossalchests", (String)"blocks/interface_obsidian"));
    }

    public static class RenderState
    extends RenderTileEntityChestBase.RenderState {
        public ChestMaterial material;
        public Direction direction;
        public boolean structureComplete;
        public Vec3 renderOffset;
        public int sizeSingular;
        public List<Vec3i> interfaceLocations;
    }
}

