/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.UncolossalChest;
import org.cyclops.colossalchests.inventory.container.ContainerUncolossalChest;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class BlockEntityUncolossalChest
extends CyclopsBlockEntity
implements MenuProvider,
LidBlockEntity {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityUncolossalChest.playSound(level, pos, blockState, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityUncolossalChest.playSound(level, pos, blockState, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState blockState, int p_155364_, int p_155365_) {
            BlockEntityUncolossalChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        public boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof ContainerUncolossalChest)) {
                return false;
            }
            Container container = ((ContainerUncolossalChest)player.containerMenu).getContainerInventory();
            return container == BlockEntityUncolossalChest.this.getInventory();
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private Component customName = null;
    private final SimpleInventory inventory = new SimpleInventory(5, 64){

        public void startOpen(ContainerUser entityPlayer) {
            super.startOpen(entityPlayer);
            BlockEntityUncolossalChest.this.startOpen(entityPlayer);
        }

        public void stopOpen(ContainerUser entityPlayer) {
            super.stopOpen(entityPlayer);
            BlockEntityUncolossalChest.this.stopOpen(entityPlayer);
        }

        public boolean stillValid(Player entityplayer) {
            return super.stillValid(entityplayer) && BlockEntityUncolossalChest.this.level.getBlockEntity(BlockEntityUncolossalChest.this.worldPosition) == BlockEntityUncolossalChest.this;
        }
    };

    public BlockEntityUncolossalChest(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_UNCOLOSSAL_CHEST.value(), blockPos, blockState);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void read(ValueInput input) {
        super.read(input);
        this.inventory.read((ValueInput)input.child("inventory").orElseThrow());
        this.customName = input.read("CustomName", ComponentSerialization.CODEC).orElse(null);
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.inventory.write(output.child("inventory"));
        if (this.customName != null) {
            output.store("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
        }
    }

    static void playSound(Level level, BlockPos pos, BlockState blockState, SoundEvent soundEvent) {
        level.playSound((Entity)((Player)null), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.2f + 1.15f);
    }

    public boolean triggerEvent(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.shouldBeOpen(value > 0);
            return true;
        }
        return super.triggerEvent(eventType, value);
    }

    public void startOpen(ContainerUser player) {
        if (!this.remove) {
            this.openersCounter.incrementOpeners(player.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState(), player.getContainerInteractionRange());
        }
    }

    public void stopOpen(ContainerUser player) {
        if (!this.remove) {
            this.openersCounter.decrementOpeners(player.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState blockState, int p_155336_, int value) {
        Block block = blockState.getBlock();
        level.blockEvent(pos, block, 1, value);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState blockState, BlockEntityUncolossalChest blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    public float getOpenNess(float value) {
        return this.chestLidController.getOpenness(value);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component getDisplayName() {
        return this.hasCustomName() ? this.customName : Component.translatable((String)"general.colossalchests.uncolossalchest");
    }

    public Direction getRotation() {
        if (this.getLevel() == null) {
            return Direction.SOUTH;
        }
        BlockState blockState = this.getLevel().getBlockState(this.getBlockPos());
        if (blockState.getBlock() != RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.value()) {
            return Direction.NORTH;
        }
        return (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(blockState, UncolossalChest.FACING, (Comparable)Direction.NORTH);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerUncolossalChest(id, playerInventory, (Container)this.getInventory());
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.getInventory());
        this.level.updateNeighbourForOutputSignal(pos, state.getBlock());
    }
}

