/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class BlockEntityColossalChestForge
extends BlockEntityColossalChest {
    private LazyOptional<IItemHandler> capabilityItemHandler = LazyOptional.empty();

    public BlockEntityColossalChestForge(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    @Override
    public void setInventory(SimpleInventory inventory) {
        this.capabilityItemHandler.invalidate();
        super.setInventory(inventory);
        if (this.inventory.getContainerSize() > 0) {
            InvWrapper itemHandler = new InvWrapper((Container)this.inventory);
            this.capabilityItemHandler = LazyOptional.of(() -> BlockEntityColossalChestForge.lambda$setInventory$0((IItemHandler)itemHandler));
        } else {
            this.capabilityItemHandler = LazyOptional.empty();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        this.ensureInventoryInitialized();
        if (this.capabilityItemHandler.isPresent() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.capabilityItemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public AABB getRenderBoundingBox() {
        int size = this.getSizeSingular();
        return new AABB(Vec3.atLowerCornerOf((Vec3i)this.getBlockPos().subtract(new Vec3i(size, size, size))), Vec3.atLowerCornerOf((Vec3i)this.getBlockPos().offset(size, size * 2, size)));
    }

    private static /* synthetic */ IItemHandler lambda$setInventory$0(IItemHandler itemHandler) {
        return itemHandler;
    }
}

