/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.blockentity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ColossalChestConfig;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.inventory.IndexedInventory;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public class BlockEntityColossalChest
extends CyclopsBlockEntity
implements MenuProvider,
LidBlockEntity {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityColossalChest.playSound(level, pos, blockState, SoundEvents.CHEST_OPEN, BlockEntityColossalChest.this.getSizeSingular());
        }

        protected void onClose(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityColossalChest.playSound(level, pos, blockState, SoundEvents.CHEST_CLOSE, BlockEntityColossalChest.this.getSizeSingular());
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState blockState, int p_155364_, int p_155365_) {
            BlockEntityColossalChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        public boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof ContainerColossalChest)) {
                return false;
            }
            Container container = ((ContainerColossalChest)player.containerMenu).getContainerInventory();
            return container == BlockEntityColossalChest.this.getInventory();
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private SimpleInventory lastValidInventory = null;
    protected SimpleInventory inventory = null;
    @NBTPersist
    private Vec3i size = IModHelpers.get().getLocationHelpers().copyLocation(Vec3i.ZERO);
    @NBTPersist
    private Vec3 renderOffset = new Vec3(0.0, 0.0, 0.0);
    private Component customName = null;
    @NBTPersist
    private int materialId = 0;
    @NBTPersist
    private int rotation = 0;
    @NBTPersist(useDefaultValue=false)
    private List<Vec3i> interfaceLocations = Lists.newArrayList();
    @NBTPersist
    private boolean disableDrops = false;
    private boolean recreateNullInventory = true;
    private EnumFacingMap<int[]> facingSlots = EnumFacingMap.newMap();

    public BlockEntityColossalChest(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_COLOSSAL_CHEST.value(), blockPos, blockState);
    }

    public Vec3i getSize() {
        return this.size;
    }

    public void setSize(Vec3i size) {
        this.size = size;
        this.facingSlots.clear();
        if (this.isStructureComplete()) {
            this.setInventory((SimpleInventory)this.constructInventory());
            if (this.lastValidInventory != null) {
                int slot;
                for (slot = 0; slot < Math.min(this.lastValidInventory.getContainerSize(), this.inventory.getContainerSize()); ++slot) {
                    ItemStack contents = this.lastValidInventory.getItem(slot);
                    if (contents.isEmpty()) continue;
                    this.inventory.setItem(slot, contents);
                    this.lastValidInventory.setItem(slot, ItemStack.EMPTY);
                }
                if (slot < this.lastValidInventory.getContainerSize()) {
                    IModHelpers.get().getInventoryHelpers().dropItems(this.getLevel(), (Container)this.lastValidInventory, this.getBlockPos());
                }
                this.lastValidInventory = null;
            }
        } else {
            this.interfaceLocations.clear();
            if (this.inventory != null) {
                if (GeneralConfig.ejectItemsOnDestroy) {
                    IModHelpers.get().getInventoryHelpers().dropItems(this.getLevel(), (Container)this.inventory, this.getBlockPos());
                    this.lastValidInventory = null;
                } else {
                    this.lastValidInventory = this.inventory;
                }
            }
            this.setInventory((SimpleInventory)new LargeInventory(0, 0));
        }
        this.onDirty();
        IModHelpers.get().getBlockHelpers().markForUpdate(this.getLevel(), this.getBlockPos());
    }

    public void setMaterial(ChestMaterial material) {
        this.materialId = material.ordinal();
    }

    public ChestMaterial getMaterial() {
        return ChestMaterial.VALUES.get(this.materialId);
    }

    public SimpleInventory getLastValidInventory() {
        return this.lastValidInventory;
    }

    public void setLastValidInventory(SimpleInventory lastValidInventory) {
        this.lastValidInventory = lastValidInventory;
    }

    public int getSizeSingular() {
        return this.getSize().getX() + 1;
    }

    protected boolean isClientSide() {
        return this.getLevel() != null && this.getLevel().isClientSide();
    }

    protected LargeInventory constructInventory() {
        if (!this.isClientSide() && GeneralConfig.creativeChests) {
            return this.constructInventoryDebug();
        }
        IndexedInventory inv = !this.isClientSide() ? new IndexedInventory(this.calculateInventorySize(), 64){

            public void startOpen(ContainerUser entityPlayer) {
                super.startOpen(entityPlayer);
                BlockEntityColossalChest.this.startOpen(entityPlayer);
            }

            public void stopOpen(ContainerUser entityPlayer) {
                super.stopOpen(entityPlayer);
                BlockEntityColossalChest.this.stopOpen(entityPlayer);
            }
        } : new LargeInventory(this.calculateInventorySize(), 64);
        inv.addDirtyMarkListener((IDirtyMarkListener)this);
        return inv;
    }

    protected LargeInventory constructInventoryDebug() {
        IndexedInventory inv = !this.isClientSide() ? new IndexedInventory(this.calculateInventorySize(), 64) : new LargeInventory(this.calculateInventorySize(), 64);
        Random random = new Random();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            inv.setItem(i, new ItemStack((ItemLike)Iterables.get((Iterable)BuiltInRegistries.ITEM, (int)random.nextInt(BuiltInRegistries.ITEM.size()))));
        }
        return inv;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        SimpleInventory oldInventory = this.inventory;
        SimpleInventory oldLastInventory = this.lastValidInventory;
        this.inventory = null;
        this.lastValidInventory = null;
        this.recreateNullInventory = false;
        CompoundTag tag = super.getUpdateTag(provider);
        this.inventory = oldInventory;
        this.lastValidInventory = oldLastInventory;
        this.recreateNullInventory = true;
        return tag;
    }

    public void read(ValueInput input) {
        SimpleInventory oldInventory = this.inventory;
        SimpleInventory oldLastInventory = this.lastValidInventory;
        if (this.getLevel() != null && this.getLevel().isClientSide()) {
            this.inventory = null;
            this.lastValidInventory = null;
            this.recreateNullInventory = false;
        }
        super.read(input);
        if (this.getLevel() != null && this.getLevel().isClientSide()) {
            this.inventory = oldInventory;
            this.lastValidInventory = oldLastInventory;
            this.recreateNullInventory = true;
        } else {
            this.getInventory().read((ValueInput)input.child("inventory").orElseThrow());
            input.child("lastValidInventory").ifPresent(child -> {
                this.lastValidInventory = new LargeInventory(((Integer)input.getInt("lastValidInventorySize").orElseThrow()).intValue(), this.inventory.getMaxStackSize());
                this.lastValidInventory.read(child);
            });
        }
        this.customName = input.read("CustomName", ComponentSerialization.CODEC).orElse(null);
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (this.customName != null) {
            output.store("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
        }
        if (this.inventory != null) {
            this.inventory.write(output.child("inventory"));
        }
        if (this.lastValidInventory != null) {
            this.lastValidInventory.write(output.child("lastValidInventory"));
            output.putInt("lastValidInventorySize", this.lastValidInventory.getContainerSize());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (blockEntity, provider) -> this.getUpdateTag((HolderLookup.Provider)provider));
    }

    protected int calculateInventorySize() {
        int size = this.getSizeSingular();
        if (size == 1) {
            return 0;
        }
        return (int)Math.ceil(Math.pow(size, 3.0) * 27.0 * this.getMaterial().getInventoryMultiplier() / 9.0) * 9;
    }

    public void setInventory(SimpleInventory inventory) {
        this.inventory = inventory;
    }

    protected void ensureInventoryInitialized() {
        if (this.getLevel() != null && this.getLevel().isClientSide() && (this.inventory == null || this.inventory.getContainerSize() != this.calculateInventorySize())) {
            this.setInventory((SimpleInventory)this.constructInventory());
        }
    }

    public INBTInventory getInventory() {
        if (this.lastValidInventory != null) {
            return new IndexedInventory();
        }
        this.ensureInventoryInitialized();
        if (this.inventory == null && this.recreateNullInventory) {
            this.setInventory((SimpleInventory)this.constructInventory());
        }
        return this.inventory;
    }

    public boolean canInteractWith(Player entityPlayer) {
        return this.getSizeSingular() > 1 && super.canInteractWith(entityPlayer);
    }

    public void setCenter(Vec3 center) {
        double dx = Math.abs(center.x - (double)this.getBlockPos().getX());
        double dz = Math.abs(center.z - (double)this.getBlockPos().getZ());
        boolean equal = center.x - (double)this.getBlockPos().getX() == center.z - (double)this.getBlockPos().getZ();
        Direction rotation = dx > dz || !equal && this.getSizeSingular() == 2 ? DirectionHelpers.getEnumFacingFromXSign((int)((int)Math.round(center.x - (double)this.getBlockPos().getX()))) : DirectionHelpers.getEnumFacingFromZSing((int)((int)Math.round(center.z - (double)this.getBlockPos().getZ())));
        this.setRotation(rotation);
        this.renderOffset = new Vec3((double)this.getBlockPos().getX() - center.x, (double)this.getBlockPos().getY() - center.y, (double)this.getBlockPos().getZ() - center.z);
    }

    public void setRotation(Direction rotation) {
        this.rotation = rotation.ordinal();
    }

    public Direction getRotation() {
        return Direction.from3DDataValue((int)this.rotation);
    }

    public Vec3 getRenderOffset() {
        return this.renderOffset;
    }

    public void setRenderOffset(Vec3 renderOffset) {
        this.renderOffset = renderOffset;
    }

    public static void detectStructure(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
    }

    public boolean isStructureComplete() {
        return !this.getSize().equals((Object)Vec3i.ZERO);
    }

    public static Vec3i getMaxSize() {
        int size = ColossalChestConfig.maxSize - 1;
        return new Vec3i(size, size, size);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public void addInterface(Vec3i blockPos) {
        this.interfaceLocations.add(blockPos);
    }

    public List<Vec3i> getInterfaceLocations() {
        return Collections.unmodifiableList(this.interfaceLocations);
    }

    public Component getDisplayName() {
        return this.hasCustomName() ? this.customName : Component.translatable((String)"general.colossalchests.colossalchest", (Object[])new Object[]{Component.translatable((String)this.getMaterial().getUnlocalizedName()), this.getSizeSingular()});
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerColossalChest(id, playerInventory, (Container)this.getInventory());
    }

    static void playSound(Level level, BlockPos pos, BlockState blockState, SoundEvent soundEvent, int size) {
        float increaseAngle = 0.15f / (float)Math.min(5, size);
        level.playSound((Entity)((Player)null), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.BLOCKS, (float)(0.5 + 0.5 * Math.log(size)), level.random.nextFloat() * 0.1f + 0.45f + increaseAngle);
    }

    public boolean triggerEvent(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.shouldBeOpen(value > 0);
            return true;
        }
        return super.triggerEvent(eventType, value);
    }

    public void startOpen(ContainerUser player) {
        if (!this.remove) {
            this.openersCounter.incrementOpeners(player.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState(), player.getContainerInteractionRange());
        }
    }

    public void stopOpen(ContainerUser player) {
        if (!this.remove) {
            this.openersCounter.decrementOpeners(player.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState blockState, int p_155336_, int value) {
        Block block = blockState.getBlock();
        level.blockEvent(pos, block, 1, value);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState blockState, BlockEntityColossalChest blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    public float getOpenNess(float value) {
        if (!GeneralConfig.visuallyOpen) {
            return 0.0f;
        }
        return this.chestLidController.getOpenness(value);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        if (!this.disableDrops) {
            SimpleInventory lastInventory = this.getLastValidInventory();
            IModHelpers.get().getInventoryHelpers().dropItems(this.getLevel(), (Container)(lastInventory != null ? lastInventory : this.getInventory()), pos);
        }
    }

    public void disableDrops() {
        this.disableDrops = true;
    }
}

