/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.advancement.criterion.ChestFormedTrigger;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.cyclopscore.block.BlockWithEntityGui;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.IBlockEntityHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Interface;

public class ColossalChest
extends BlockWithEntityGui
implements CubeDetector.IDetectionListener,
IBlockChestMaterial {
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    protected final ChestMaterial material;
    public final MapCodec<ColossalChest> codec;

    public ColossalChest(BlockBehaviour.Properties properties, ChestMaterial material, BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntity> blockEntitySupplier) {
        super(properties, blockEntitySupplier);
        this.material = material;
        this.codec = BlockBehaviour.simpleCodec(props -> new ColossalChest((BlockBehaviour.Properties)props, material, blockEntitySupplier));
        material.setBlockCore(this);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState p_49234_, Level p_49235_, BlockPos p_49236_) {
        return super.getMenuProvider(p_49234_, p_49235_, p_49236_);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_COLOSSAL_CHEST.value()), BlockEntityColossalChest::lidAnimateTick) : null;
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlockEntityColossalChest) {
            BlockEntityColossalChest uncolossalChest = (BlockEntityColossalChest)blockEntity;
            uncolossalChest.recheckOpen();
        }
    }

    @Override
    public ChestMaterial getMaterial() {
        return this.material;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ENABLED});
    }

    public static boolean canPlace(LevelReader world, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockState blockState = world.getBlockState(pos.relative(side));
            Block block = blockState.getBlock();
            if (!(block instanceof ColossalChest) && !(block instanceof ChestWall) && !(block instanceof Interface) || !blockState.getProperties().contains(ENABLED) || !((Boolean)blockState.getValue((Property)ENABLED)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)ENABLED) != false ? RenderShape.MODEL : super.getRenderShape(blockState);
    }

    public boolean propagatesSkylightDown(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)ENABLED);
    }

    public static DetectionResult triggerDetector(ChestMaterial material, LevelAccessor world, BlockPos blockPos, boolean valid, @javax.annotation.Nullable Player player, boolean changeState) {
        BlockState blockState;
        DetectionResult detectionResult = material.getChestDetector().detect((LevelReader)world, blockPos, valid ? null : blockPos, (CubeDetector.IValidationAction)new MaterialValidationAction(), changeState);
        if (player instanceof ServerPlayer && detectionResult.getError() == null && ((Boolean)(blockState = world.getBlockState(blockPos)).getValue((Property)ENABLED)).booleanValue()) {
            BlockEntityColossalChest tile = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, blockPos, BlockEntityColossalChest.class).orElse(null);
            if (tile == null) {
                BlockPos corePos = ColossalChest.getCoreLocation(material, (LevelReader)world, blockPos);
                tile = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, corePos, BlockEntityColossalChest.class).orElse(null);
            }
            ((ChestFormedTrigger)((Object)RegistryEntries.TRIGGER_CHEST_FORMED.value())).test((ServerPlayer)player, material, tile.getSizeSingular());
        }
        return detectionResult;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntityColossalChest tile;
        super.setPlacedBy(world, pos, state, placer, stack);
        if (stack.has(DataComponents.CUSTOM_NAME) && (tile = (BlockEntityColossalChest)IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, BlockEntityColossalChest.class).orElse(null)) != null) {
            tile.setCustomName(stack.getHoverName());
            tile.setSize(Vec3i.ZERO);
        }
        ColossalChest.triggerDetector(this.material, (LevelAccessor)world, pos, true, placer instanceof Player ? (Player)placer : null, true);
    }

    public void onPlace(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.onPlace(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!this.isCaptureBlockSnapshots(world) && blockStateNew.getBlock() != blockStateOld.getBlock() && !((Boolean)blockStateNew.getValue((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (LevelAccessor)world, blockPos, true, null, true);
        }
    }

    protected boolean isCaptureBlockSnapshots(Level level) {
        return false;
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.getBlockState(location).getBlock();
        if (block == this) {
            ((LevelWriter)world).setBlock(location, (BlockState)world.getBlockState(location).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(valid)), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
            BlockEntityColossalChest tile = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, location, BlockEntityColossalChest.class).orElse(null);
            if (tile != null) {
                tile.setMaterial(this.material);
                tile.setSize(valid ? size : Vec3i.ZERO);
                tile.setCenter(new Vec3((double)originCorner.getX() + (double)size.getX() / 2.0, (double)originCorner.getY() + (double)size.getY() / 2.0, (double)originCorner.getZ() + (double)size.getZ() / 2.0));
                tile.addInterface((Vec3i)location);
            }
        }
    }

    @javax.annotation.Nullable
    public static BlockPos getCoreLocation(ChestMaterial material, LevelReader world, BlockPos blockPos) {
        Wrapper tileLocationWrapper = new Wrapper();
        material.getChestDetector().detect(world, blockPos, null, (location, blockState) -> {
            if (blockState.getBlock() instanceof ColossalChest) {
                tileLocationWrapper.set((Object)location);
            }
            return null;
        }, false);
        return (BlockPos)tileLocationWrapper.get();
    }

    public static void addPlayerChatError(ChestMaterial material, Level world, BlockPos blockPos, Player player) {
        if (!world.isClientSide() && player.getItemInHand(player.getUsedItemHand()).isEmpty()) {
            DetectionResult result = material.getChestDetector().detect((LevelReader)world, blockPos, null, (CubeDetector.IValidationAction)new MaterialValidationAction(), false);
            if (result != null && result.getError() != null) {
                ColossalChest.addPlayerChatError(player, result.getError());
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"multiblock.colossalchests.error.unexpected"), true);
            }
        }
    }

    public static void addPlayerChatError(Player player, Component error) {
        MutableComponent chat = Component.literal((String)"");
        MutableComponent prefix = Component.literal((String)"[").append((Component)Component.translatable((String)"multiblock.colossalchests.error.prefix")).append((Component)Component.literal((String)"]: ")).setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"multiblock.colossalchests.error.prefix.info"))));
        chat.append((Component)prefix);
        chat.append(error);
        player.displayClientMessage((Component)chat, true);
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, Player player, BlockPos blockPos, BlockHitResult rayTraceResult) {
        IBlockEntityHelpers blockEntityHelpers = IModHelpers.get().getBlockEntityHelpers();
        blockEntityHelpers.setUnsafeBlockEntityGetter(true);
        blockEntityHelpers.get((BlockGetter)world, blockPos, BlockEntityColossalChest.class).ifPresent(tile -> packetBuffer.writeInt(tile.getInventory().getContainerSize()));
        blockEntityHelpers.setUnsafeBlockEntityGetter(false);
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult rayTraceResult) {
        if (!((Boolean)blockState.getValue((Property)ENABLED)).booleanValue()) {
            ColossalChest.addPlayerChatError(this.material, world, blockPos, player);
            return InteractionResult.FAIL;
        }
        return super.useWithoutItem(blockState, world, blockPos, player, rayTraceResult);
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, world, blockPos, false, null, true);
        }
        super.destroy(world, blockPos, blockState);
    }

    public boolean canSurvive(BlockState blockState, LevelReader world, BlockPos blockPos) {
        return super.canSurvive(blockState, world, blockPos) && ColossalChest.canPlace(world, blockPos);
    }

    public void onBlockExplodedCommon(BlockState state, ServerLevel world, BlockPos pos, Explosion explosion) {
        if (((Boolean)world.getBlockState(pos).getValue((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (LevelAccessor)world, pos, false, null, true);
        }
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.wasExploded(world, pos, explosion);
    }

    public float getExplosionResistance() {
        if (this.material.isExplosionResistant()) {
            return 10000.0f;
        }
        return 0.0f;
    }

    private static class MaterialValidationAction
    implements CubeDetector.IValidationAction {
        private final Wrapper<ChestMaterial> requiredMaterial = new Wrapper(null);

        public Component onValidate(BlockPos blockPos, BlockState blockState) {
            ChestMaterial material = null;
            if (blockState.getBlock() instanceof IBlockChestMaterial) {
                material = ((IBlockChestMaterial)blockState.getBlock()).getMaterial();
            }
            if (this.requiredMaterial.get() == null) {
                this.requiredMaterial.set((Object)material);
                return null;
            }
            return this.requiredMaterial.get() == material ? null : Component.translatable((String)"multiblock.colossalchests.error.material", (Object[])new Object[]{Component.translatable((String)material.getUnlocalizedName()), IModHelpers.get().getLocationHelpers().toCompactString(blockPos), Component.translatable((String)((ChestMaterial)this.requiredMaterial.get()).getUnlocalizedName())});
        }
    }
}

