/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.villagernames_common_neoforge.config.ConfigHandler;
import com.natamus.villagernames_common_neoforge.data.Variables;
import com.natamus.villagernames_common_neoforge.util.Names;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.villager.Villager;

public class Util {
    private static final List<String> namesToOverwrite = new ArrayList<String>(Arrays.asList("Bowman", "Crossbowman", "Horseman", "Nomad", "Recruit", "Shieldman"));

    public static boolean shouldOverwriteName(Entity entity) {
        return namesToOverwrite.contains(entity.getName().getString());
    }

    public static MutableComponent getTradeScreenTitle() {
        Component name = (Component)Variables.tradedVillagerPair.getFirst();
        Component profession = (Component)Variables.tradedVillagerPair.getSecond();
        if (!ConfigHandler.showProfessionOnTradeScreen) {
            return name.copy();
        }
        if (name.equals((Object)Component.empty()) || profession.equals((Object)Component.empty())) {
            return null;
        }
        MutableComponent newTitle = Component.empty();
        newTitle = !ConfigHandler.switchNameAndProfessionTradeScreen ? newTitle.append(name).append(" | ").append(profession) : newTitle.append(profession).append(" | ").append(name);
        return newTitle;
    }

    public static int unnameLoadedVillagers(ServerLevel serverLevel) {
        int unnameCount = 0;
        for (Entity entity : serverLevel.getAllEntities()) {
            if (!(entity instanceof Villager) && !EntityFunctions.isModdedVillager((Entity)entity) || !entity.hasCustomName()) continue;
            entity.setCustomName(null);
            entity.removeTag("villagernames.named");
            ++unnameCount;
        }
        return unnameCount;
    }

    public static int nameLoadedVillagers(ServerLevel serverLevel) {
        int nameCount = 0;
        for (Entity entity : serverLevel.getAllEntities()) {
            if (!(entity instanceof Villager) && !EntityFunctions.isModdedVillager((Entity)entity) || entity.hasCustomName()) continue;
            EntityFunctions.nameEntity((Entity)entity, (String)Names.getRandomName());
            entity.addTag("villagernames.named");
            ++nameCount;
        }
        return nameCount;
    }

    public static int renameLoadedVillagers(ServerLevel serverLevel) {
        Util.unnameLoadedVillagers(serverLevel);
        return Util.nameLoadedVillagers(serverLevel);
    }
}

