/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz.objects;

import com.mcwdoors.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GarageDoorNew
extends Block {
    public static final EnumProperty<GaragePart> PART = EnumProperty.create((String)"part", GaragePart.class);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape EAST = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public GarageDoorNew(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(PART, (Comparable)((Object)GaragePart.TOP)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, POWERED, PART});
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue(FACING);
        return facing == Direction.WEST || facing == Direction.EAST ? NORTH : EAST;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((Boolean)state.getValue((Property)OPEN)).booleanValue() ? (state.getValue(FACING) == Direction.WEST || state.getValue(FACING) == Direction.EAST ? NORTH : EAST) : Shapes.empty();
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == this.asItem()) {
            return InteractionResult.PASS;
        }
        boolean open = (Boolean)state.getValue((Property)OPEN) == false;
        this.toggleDoor(level, pos, open, (Direction)state.getValue(FACING));
        level.playSound(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.8f);
        return InteractionResult.SUCCESS;
    }

    private void toggleDoor(Level level, BlockPos clickedPos, boolean open, Direction facing) {
        BlockPos topPos = clickedPos;
        while (level.getBlockState(topPos.above()).getBlock() == this) {
            topPos = topPos.above();
        }
        BlockState topState = level.getBlockState(topPos);
        if (topState.getBlock() != this) {
            return;
        }
        level.setBlock(topPos, (BlockState)topState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        if (!open) {
            current = topPos.below();
            while (level.getBlockState(current).isAir()) {
                level.setBlock(current, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing)).setValue(PART, (Comparable)((Object)GaragePart.MIDDLE))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
                current = current.below();
            }
        } else {
            current = topPos.below();
            while (level.getBlockState(current).getBlock() == this) {
                level.setBlock(current, Blocks.AIR.defaultBlockState(), 3);
                current = current.below();
            }
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos adjacent;
                BlockState adjState;
                if (dx == 0 && dz == 0 || (adjState = level.getBlockState(adjacent = topPos.offset(dx, 0, dz))).getBlock() != this || (Boolean)adjState.getValue((Property)OPEN) == open) continue;
                this.toggleDoor(level, adjacent, open, (Direction)adjState.getValue(FACING));
            }
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation neighborPos, boolean isMoving) {
        if (!level.isClientSide()) {
            boolean powered;
            boolean bl = powered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.below());
            if ((Boolean)state.getValue((Property)POWERED) != powered) {
                this.toggleDoor(level, pos, powered, (Direction)state.getValue(FACING));
                level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
            }
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathtype) {
        return false;
    }

    public static enum GaragePart implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

